/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.model;

import edu.sc.seis.sod.validator.model.Annotation;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;

public abstract class AbstractForm
implements Form {
    private Definition def;
    private int min;
    private int max;
    private Form parent;
    private Annotation ann = new Annotation();
    private String namespace;

    public AbstractForm(int min, int max) {
        this(min, max, null);
    }

    public AbstractForm(int min, int max, Form parent) {
        this.min = min;
        this.max = max;
        this.parent = parent;
        this.ann.setFormProvider(this);
    }

    @Override
    public boolean isAncestorOf(Form f) {
        return this.isAncestorOf(f, null);
    }

    @Override
    public boolean isAncestorOf(Form f, Form root) {
        return false;
    }

    @Override
    public Form getParent() {
        return this.parent;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public void setMin(int min) {
        this.min = min;
    }

    @Override
    public Form getForm() {
        return this;
    }

    @Override
    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public boolean isFromDef() {
        return this.getDef() != null;
    }

    @Override
    public Definition getDef() {
        return this.def;
    }

    @Override
    public Form deref(Form newParent, Definition newDef) {
        AbstractForm copy = (AbstractForm)this.copyWithNewParent(newParent);
        copy.def = newDef;
        return copy;
    }

    @Override
    public void setAnnotation(Annotation ann) {
        this.ann = ann;
        ann.setFormProvider(this);
    }

    @Override
    public Annotation getAnnotation() {
        return this.ann;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getXPath() {
        if (this.parent == null) {
            return "/";
        }
        return this.getParent().getXPath();
    }

    public void copyGutsOver(AbstractForm copy) {
        copy.setAnnotation(this.getAnnotation().makeCopyWithNewFormProvider(copy));
        copy.def = this.getDef();
    }
}

