/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator;

import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.SinglePropertyMap;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.io.IOException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Validator {
    private ErrorHandler quietEH = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) {
        }

        @Override
        public void error(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) {
        }
    };
    private ErrorHandler verboseEH = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) {
            this.handle(exception);
        }

        @Override
        public void error(SAXParseException exception) {
            this.handle(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.handle(exception);
        }

        private void handle(SAXParseException ex) {
            Validator.this.errorMessage = "The strategy file is invalid.  SOD requires strategy files that conform to a set structure.  See the ingredient reference in the docs that came with SOD for help with this.\n\n";
            Validator.this.errorMessage = Validator.this.errorMessage + "There appears to be something wrong on line " + ex.getLineNumber() + ". ";
            Validator.this.errorMessage = Validator.this.errorMessage + "The validator says '" + ex.getLocalizedMessage() + "'\n\n";
        }
    };
    private String errorMessage;
    private String schemaLoc = "edu/sc/seis/sod/data/sod.rng";
    public static final String SOD_SCHEMA_LOC = "edu/sc/seis/sod/data/sod.rng";
    private ValidationDriver verboseDriver;
    private ValidationDriver driver;

    public Validator(String schemaLoc) {
        this.schemaLoc = schemaLoc;
    }

    public Validator() {
        this(SOD_SCHEMA_LOC);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean validate(InputSource in) throws IOException, SAXException {
        return this.validate(in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(InputSource in, boolean verbose) throws IOException, SAXException {
        if (verbose) {
            if (this.verboseDriver == null) {
                this.verboseDriver = this.createDriver(true);
            }
            ValidationDriver validationDriver = this.verboseDriver;
            synchronized (validationDriver) {
                return this.verboseDriver.validate(in);
            }
        }
        if (this.driver == null) {
            this.driver = this.createDriver(false);
        }
        ValidationDriver validationDriver = this.driver;
        synchronized (validationDriver) {
            return this.driver.validate(in);
        }
    }

    private ValidationDriver createDriver(boolean verbose) {
        SinglePropertyMap pm = !verbose ? SinglePropertyMap.newInstance((PropertyId)ValidateProperty.ERROR_HANDLER, (Object)this.quietEH) : SinglePropertyMap.newInstance((PropertyId)ValidateProperty.ERROR_HANDLER, (Object)this.verboseEH);
        ValidationDriver newDriver = new ValidationDriver((PropertyMap)pm);
        try {
            newDriver.loadSchema(this.getSchemaSource());
        }
        catch (IOException e) {
            GlobalExceptionHandler.handle((String)"Trouble loading the schema for validation.  Exiting.", (Throwable)e);
            System.exit(1);
        }
        catch (SAXException e) {
            GlobalExceptionHandler.handle((String)"The loaded schema is not well formed.  Exiting.", (Throwable)e);
            System.exit(1);
        }
        return newDriver;
    }

    private InputSource getSchemaSource() {
        ClassLoader loader = Validator.class.getClassLoader();
        InputSource inSource = new InputSource(loader.getResourceAsStream(this.schemaLoc));
        inSource.setSystemId(loader.getResource(this.schemaLoc).toString());
        return inSource;
    }
}

