/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.station;

import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class StationCode
implements StationSubsetter {
    String code;
    Pattern pattern;

    public StationCode(Element config) throws ConfigurationException {
        this.code = SodUtil.getNestedText(config);
        Pattern simpleCode = Pattern.compile("[A-Z0-9]+");
        if (simpleCode.matcher(this.code).matches() && this.code.trim().length() > 5) {
            throw new ConfigurationException("Station codes are limited to 5 characters, not " + this.code.trim().length() + " as in '" + this.code.trim() + "'");
        }
        this.pattern = Pattern.compile(StationCode.createRegexFromGlob(this.code));
    }

    @Override
    public StringTree accept(StationImpl station, NetworkSource network) {
        if (this.code.equalsIgnoreCase(station.get_code())) {
            return new Pass(this);
        }
        if (this.pattern.matcher(station.get_code()).matches()) {
            return new Pass(this);
        }
        return new Fail(this);
    }

    public String getCode() {
        return this.code;
    }

    public static String createRegexFromGlob(String glob) {
        String out = "^";
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out = out + ".*";
                    continue block6;
                }
                case '?': {
                    out = out + '.';
                    continue block6;
                }
                case '.': {
                    out = out + "\\.";
                    continue block6;
                }
                case '\\': {
                    out = out + "\\\\";
                    continue block6;
                }
                default: {
                    out = out + c;
                }
            }
        }
        out = out + '$';
        return out;
    }
}

