/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.request;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.subsetter.request.BreqFastRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Element;

public class NetDCRequest
extends BreqFastRequest {
    private ThreadSafeSimpleDateFormat netDCTimeFormat = new ThreadSafeSimpleDateFormat("'\"'yyyy MM dd HH mm ss.SSSS'\"'", TimeZone.getTimeZone("GMT"));

    public NetDCRequest(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    protected void insertRequest(Channel channel, RequestFilter[] request, Writer out, int i) throws IOException {
        MicroSecondDate start = new MicroSecondDate(request[i].start_time);
        MicroSecondDate end = new MicroSecondDate(request[i].end_time);
        out.write(".DATA * " + channel.get_id().network_id.network_code + " " + channel.get_id().station_code + " " + channel.get_id().site_code + " " + channel.get_code() + " " + this.netDCTimeFormat.format((Date)start) + " " + this.netDCTimeFormat.format((Date)end) + "\n");
    }

    @Override
    protected void insertEventHeader(EventAccessOperations event, Writer out, String label) throws IOException {
        out.write(".NETDC_REQUEST\n");
        this.insert(out, "name");
        this.insert(out, "inst");
        this.optInsert(out, "mail");
        this.insert(out, "email");
        this.optInsert(out, "phone");
        this.optInsert(out, "fax");
        out.write(".LABEL " + label + "\n");
        this.optInsert(out, "media");
        this.optInsert(out, "altmedia", "ALTERNATIVE MEDIA");
        this.optInsert(out, "format_waveform");
        this.optInsert(out, "format_response");
        this.optInsert(out, "merge_data");
        this.optInsert(out, "disposition");
        out.write(".END\n");
        out.write("\n");
    }

    @Override
    protected String getDefaultWorkingDir() {
        return "netdc";
    }

    @Override
    protected String getDefaultFileTemplate() {
        return "${event.getTime('yyyy.DDD.HH.mm.ss.SSSS')}.netdc";
    }
}

