/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.MicroSecondDateSupplier;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.NetworkTimeRange;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OriginTimeRange
implements OriginSubsetter,
MicroSecondTimeRangeSupplier {
    private MicroSecondDateSupplier begin;
    private MicroSecondDateSupplier end;

    public OriginTimeRange(Element config) throws ConfigurationException {
        this.begin = this.makeLoader(config, "startTime");
        this.end = this.makeLoader(config, "endTime");
    }

    private MicroSecondDateSupplier makeLoader(Element config, String time) throws ConfigurationException {
        Element timeEl = DOMHelper.getElement((Element)config, (String)time);
        Node network = null;
        for (int i = 0; i < timeEl.getChildNodes().getLength(); ++i) {
            if (!(timeEl.getChildNodes().item(i) instanceof Element) || !timeEl.getChildNodes().item(i).getLocalName().startsWith("network")) continue;
            network = (Element)timeEl.getChildNodes().item(i);
            break;
        }
        if (network != null) {
            final String netElName = network.getLocalName();
            final NetworkTimeRange ntr = new NetworkTimeRange();
            return new MicroSecondDateSupplier(){

                @Override
                public MicroSecondDate load() {
                    if (netElName.indexOf("Start") != -1) {
                        return ntr.getMSTR().getBeginTime();
                    }
                    return ntr.getMSTR().getEndTime();
                }
            };
        }
        return SodUtil.loadTime(timeEl, time.indexOf("end") != -1);
    }

    @Override
    public synchronized MicroSecondTimeRange getMSTR() {
        return new MicroSecondTimeRange(this.begin.load(), this.end.load());
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        return new StringTreeLeaf(this, this.getMSTR().contains(new MicroSecondDate(origin.getOriginTime())));
    }
}

