/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.SeismicHardware;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstrumentationSubsetter
implements ChannelSubsetter {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationSubsetter.class);

    protected SeismicHardware getSeismicHardware(ChannelImpl channel, NetworkSource network) throws ChannelNotFound, InvalidResponse, SodSourceException {
        return this.getSeismicHardware(network.getInstrumentation(channel));
    }

    protected abstract SeismicHardware getSeismicHardware(Instrumentation var1);

    protected boolean acceptId(ChannelImpl channel, NetworkSource network, int id) {
        try {
            return this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network).id_number == id;
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptManufacturer(ChannelImpl channel, NetworkSource network, String manufacturer) {
        try {
            return manufacturer.equals(this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network).manufacturer);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptModel(ChannelImpl channel, NetworkSource network, String model) {
        try {
            return model.equals(this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network).model);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptSerialNumber(ChannelImpl channel, NetworkSource network, String serialNum) {
        try {
            return serialNum.equals(this.getSeismicHardware((ChannelImpl)channel, (NetworkSource)network).serial_number);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
        catch (SodSourceException ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    public static String getChannelNotFoundMsg() {
        return "Channel not found in network, generally indicates no response for this channel in the server.";
    }

    public static void handleChannelNotFound(ChannelNotFound ex) {
        logger.info(InstrumentationSubsetter.getChannelNotFoundMsg(), (Throwable)ex);
    }

    public static String getInstrumentationInvalidMsg() {
        return "Invalid instrumentation ";
    }

    public static void handle(InvalidResponse e) {
        logger.info(InstrumentationSubsetter.getInstrumentationInvalidMsg(), (Throwable)e);
    }

    public static void handle(SodSourceException e) {
        logger.info("Problem loading Instrumentation", (Throwable)e);
    }
}

