/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.availableData;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import java.util.Date;
import org.w3c.dom.Element;

public class PostEventWait
implements AvailableDataSubsetter {
    private TimeInterval postOriginTime;

    public PostEventWait(Element config) throws ConfigurationException {
        this.postOriginTime = SodUtil.loadTimeInterval(config);
    }

    @Override
    public StringTree accept(CacheEvent ev, ChannelImpl chan, RequestFilter[] request, RequestFilter[] available, CookieJar cookies) {
        MicroSecondDate originTime = new MicroSecondDate(EventUtil.extractOrigin((EventAccessOperations)ev).getOriginTime());
        MicroSecondDate waitTime = originTime.add(this.postOriginTime);
        if (!waitTime.after((Date)ClockUtil.now())) {
            return new StringTreeLeaf(this, false, "Wait until: " + waitTime);
        }
        return new StringTreeLeaf(this, true);
    }
}

