/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter;

import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeUtils;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.subsetter.Subsetter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class EffectiveTimeOverlap
implements Subsetter {
    private MicroSecondTimeRangeSupplier timeRange;
    private static Logger logger = LoggerFactory.getLogger(EffectiveTimeOverlap.class);

    public EffectiveTimeOverlap(MicroSecondTimeRangeSupplier timeRange) {
        this.timeRange = timeRange;
    }

    public EffectiveTimeOverlap(TimeRange range) {
        this(new MicroSecondDate(range.start_time), new MicroSecondDate(range.end_time));
    }

    public EffectiveTimeOverlap(final MicroSecondDate start, final MicroSecondDate end) {
        this.timeRange = new MicroSecondTimeRangeSupplier(){
            MicroSecondTimeRange range;
            {
                this.range = new MicroSecondTimeRange(start, end);
            }

            @Override
            public MicroSecondTimeRange getMSTR() {
                return this.range;
            }
        };
    }

    public EffectiveTimeOverlap(Element config) throws ConfigurationException {
        this.timeRange = SodUtil.loadTimeRange(config);
    }

    public boolean overlaps(TimeRange otherRange) {
        MicroSecondDate otherStart = new MicroSecondDate(otherRange.start_time);
        MicroSecondDate otherEnd = otherRange.end_time.date_time.equals("edu.iris.Fissures/Time/UNKNOWN") ? new MicroSecondDate(TimeUtils.future) : new MicroSecondDate(otherRange.end_time);
        return this.overlaps(otherStart, otherEnd);
    }

    public boolean overlaps(MicroSecondDate otherStart, MicroSecondDate otherEnd) {
        MicroSecondTimeRange mstr = this.timeRange.getMSTR();
        MicroSecondDate start = mstr.getBeginTime();
        MicroSecondDate end = mstr.getEndTime();
        if (end == null && start == null) {
            return true;
        }
        if (end == null && start.before((Date)otherEnd)) {
            return true;
        }
        if (start == null && end.after((Date)otherStart)) {
            return true;
        }
        return !otherStart.after((Date)end) && !otherEnd.before((Date)start);
    }
}

