/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.eventArm;

import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.eventArm.EventGroupTemplate;
import edu.sc.seis.sod.status.eventArm.EventMonitor;
import edu.sc.seis.sod.status.eventArm.MapEventStatus;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EventStatusTemplate
extends FileWritingTemplate
implements EventMonitor,
WaveformMonitor {
    private static Map elementsToMaps = new HashMap();
    private boolean addedToWaveformArm = false;
    private Logger logger = LoggerFactory.getLogger(EventStatusTemplate.class);
    private String armStatus = "";

    public EventStatusTemplate(Element el) throws IOException, SAXException, ParserConfigurationException, ConfigurationException {
        super(FileWritingTemplate.getBaseDirectoryName(), EventStatusTemplate.extractConstructorFilenameArg(el));
        Element config = TemplateFileLoader.getTemplate(el);
        config.removeChild(SodUtil.getElement(config, "filename"));
        this.parse(config);
    }

    private static String extractConstructorFilenameArg(Element el) throws IOException, SAXException, ParserConfigurationException, DOMException {
        Element templateConfig = TemplateFileLoader.getTemplate(el);
        Element fileNameElement = SodUtil.getElement(templateConfig, "filename");
        String filename = fileNameElement.getFirstChild().getNodeValue();
        return filename;
    }

    @Override
    public void setArmStatus(String status) {
        this.armStatus = status;
        this.write();
    }

    @Override
    public Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("events")) {
            return new EventGroupTemplate(el);
        }
        if (tag.equals("armStatus")) {
            return new ArmStatusFormatter();
        }
        if (tag.equals("mapEventStatus")) {
            return new MapImgSrc(el);
        }
        return super.getTemplate(tag, el);
    }

    @Override
    public void update(EventNetworkPair ecp) {
        this.write();
    }

    @Override
    public void update(EventStationPair ecp) {
        this.write();
    }

    @Override
    public void update(EventChannelPair ecp) {
        this.write();
    }

    @Override
    public void update(EventVectorPair ecp) {
        this.write();
    }

    @Override
    public void change(CacheEvent event, Status status) {
        if (!this.addedToWaveformArm && Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().addStatusMonitor(this);
            this.addedToWaveformArm = true;
        }
        this.write();
    }

    private class ArmStatusFormatter
    implements GenericTemplate {
        private ArmStatusFormatter() {
        }

        @Override
        public String getResult() {
            return EventStatusTemplate.this.armStatus;
        }
    }

    private class MapImgSrc
    implements GenericTemplate {
        private MapEventStatus map;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MapImgSrc(Element el) {
            String mapFileLoc = MapEventStatus.getLocation(el);
            Map map = elementsToMaps;
            synchronized (map) {
                if (elementsToMaps.containsKey(mapFileLoc)) {
                    this.map = (MapEventStatus)elementsToMaps.get(mapFileLoc);
                } else {
                    this.map = new MapEventStatus(el);
                    elementsToMaps.put(mapFileLoc, this.map);
                }
            }
        }

        @Override
        public String getResult() {
            String myloc = EventStatusTemplate.this.getOutputDirectory().toString() + '/' + EventStatusTemplate.this.getFilename();
            return SodUtil.getRelativePath(myloc, this.map.getLocation(), "/");
        }
    }
}

