/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.NetworkGroupTemplate;
import edu.sc.seis.sod.status.NetworkTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TimeTemplate;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class NetworkFormatter
extends Template
implements NetworkTemplate {
    private NetworkGroupTemplate ngt;

    public NetworkFormatter(Element el) throws ConfigurationException {
        this(el, null);
    }

    public NetworkFormatter(Element el, NetworkGroupTemplate ngt) throws ConfigurationException {
        this.ngt = ngt;
        this.parse(el);
    }

    @Override
    public String getResult(NetworkAttr network) {
        StringBuffer buf = new StringBuffer();
        for (NetworkTemplate cur : this.templates) {
            buf.append(cur.getResult(network));
        }
        return buf.toString();
    }

    @Override
    protected Object textTemplate(final String text) {
        return new NetworkTemplate(){

            @Override
            public String getResult(NetworkAttr net) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, final Element el) {
        if (tag.equals("networkCode")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    return net.get_code();
                }
            };
        }
        if (tag.equals("beginTime")) {
            return new NetworkTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(NetworkAttr net) {
                    return this.btt.getResult(net.get_id().begin_time);
                }
            };
        }
        if (tag.equals("endTime")) {
            return new NetworkTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(NetworkAttr net) {
                    return this.btt.getResult(net.getEffectiveTime().end_time);
                }
            };
        }
        if (tag.equals("beginTimeUnformatted")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    return net.get_id().begin_time.date_time;
                }
            };
        }
        if (tag.equals("name")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    return net.getName();
                }
            };
        }
        if (tag.equals("firstWord")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    if (net.getName() == null || net.getName().equals("")) {
                        return "";
                    }
                    StringTokenizer tok = new StringTokenizer(net.getName(), " /,.-");
                    return tok.nextToken();
                }
            };
        }
        if (tag.equals("description")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    return net.getDescription();
                }
            };
        }
        if (tag.equals("owner")) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    return net.getOwner();
                }
            };
        }
        if (tag.equals("status") && this.ngt != null) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    String id = NetworkIdUtil.toString((NetworkId)net.get_id());
                    return ((NetworkFormatter)NetworkFormatter.this).ngt.statusMap.get(id).toString();
                }
            };
        }
        if (tag.equals("standing") && this.ngt != null) {
            return new NetworkTemplate(){

                @Override
                public String getResult(NetworkAttr net) {
                    String id = NetworkIdUtil.toString((NetworkId)net.get_id());
                    Status status = (Status)((NetworkFormatter)NetworkFormatter.this).ngt.statusMap.get(id);
                    return status.getStanding().toString();
                }
            };
        }
        return this.getCommonTemplate(tag, el);
    }
}

