/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.ChannelGroupTemplate;
import edu.sc.seis.sod.status.ChannelTemplate;
import edu.sc.seis.sod.status.FissuresFormatter;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.TimeTemplate;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class ChannelFormatter
extends Template
implements ChannelTemplate {
    private DecimalFormat formatter = new DecimalFormat("#.#");
    boolean filizeResults = false;
    ChannelGroupTemplate cgt;

    public ChannelFormatter() {
        this.templates = new ArrayList();
        this.templates.add(this.getTemplate("id", null));
    }

    public static ChannelFormatter makeSiteAndCode() {
        ChannelFormatter formatter = new ChannelFormatter();
        formatter.templates.clear();
        formatter.templates.add(formatter.getTemplate("siteCode", null));
        formatter.templates.add(formatter.textTemplate("."));
        formatter.templates.add(formatter.getTemplate("channelCode", null));
        return formatter;
    }

    public ChannelFormatter(Element el) throws ConfigurationException {
        this(el, null);
    }

    public ChannelFormatter(Element el, boolean filize) throws ConfigurationException {
        this(el, null, filize);
    }

    public ChannelFormatter(Element el, ChannelGroupTemplate cgt) throws ConfigurationException {
        this(el, cgt, false);
    }

    public ChannelFormatter(Element el, ChannelGroupTemplate cgt, boolean filize) throws ConfigurationException {
        this.cgt = cgt;
        this.parse(el, filize);
        this.filizeResults = filize;
    }

    @Override
    protected Object textTemplate(final String text) {
        return new ChannelTemplate(){

            @Override
            public String getResult(Channel chan) {
                return text;
            }
        };
    }

    @Override
    protected Object getTemplate(String tag, final Element el) {
        if (tag.equals("stationCode")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.get_id().station_code;
                }
            };
        }
        if (tag.equals("channelCode")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.get_id().channel_code;
                }
            };
        }
        if (tag.equals("networkCode")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.get_id().network_id.network_code;
                }
            };
        }
        if (tag.equals("stationCode")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.get_code();
                }
            };
        }
        if (tag.equals("siteCode")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    if (chan.get_id().site_code.trim().length() == 0 && ChannelFormatter.this.filizeResults) {
                        return "__";
                    }
                    return chan.get_id().site_code;
                }
            };
        }
        if (tag.equals("beginTime")) {
            return new ChannelTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Channel chan) {
                    return this.btt.getResult(chan.get_id().begin_time);
                }
            };
        }
        if (tag.equals("endTime")) {
            return new ChannelTemplate(){
                TimeTemplate btt;
                {
                    this.btt = new TimeTemplate(el, false);
                }

                @Override
                public String getResult(Channel chan) {
                    return this.btt.getResult(chan.getEndTime());
                }
            };
        }
        if (tag.equals("beginTimeUnformatted")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.get_id().begin_time.date_time;
                }
            };
        }
        if (tag.equals("dip")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.format(chan.getOrientation().dip);
                }
            };
        }
        if (tag.equals("azimuth")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.format(chan.getOrientation().azimuth);
                }
            };
        }
        if (tag.equals("name")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return chan.getName();
                }
            };
        }
        if (tag.equals("lat")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.format(chan.getSite().getLocation().latitude);
                }
            };
        }
        if (tag.equals("lon")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.format(chan.getSite().getLocation().longitude);
                }
            };
        }
        if (tag.equals("lon")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.format(chan.getSite().getLocation().longitude);
                }
            };
        }
        if (tag.equals("status") && this.cgt != null) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelFormatter.this.cgt.getStatus(chan);
                }
            };
        }
        if (tag.equals("standing") && this.cgt != null) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    Status status = (Status)ChannelFormatter.this.cgt.channelMap.get(chan);
                    return status.getStanding().toString();
                }
            };
        }
        if (tag.equals("id")) {
            return new ChannelTemplate(){

                @Override
                public String getResult(Channel chan) {
                    return ChannelIdUtil.toString((ChannelId)chan.get_id());
                }
            };
        }
        return super.getCommonTemplate(tag, el);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(double d) {
        DecimalFormat decimalFormat = this.formatter;
        synchronized (decimalFormat) {
            return this.formatter.format(d);
        }
    }

    @Override
    public String getResult(Channel chan) {
        StringBuffer buf = new StringBuffer();
        for (ChannelTemplate cur : this.templates) {
            buf.append(cur.getResult(chan));
        }
        if (this.filizeResults) {
            return FissuresFormatter.filize(buf.toString());
        }
        return buf.toString();
    }
}

