/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.channel.ChannelCode;
import edu.sc.seis.sod.subsetter.channel.ChannelOR;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.channel.SiteCode;
import edu.sc.seis.sod.subsetter.network.NetworkCode;
import edu.sc.seis.sod.subsetter.network.NetworkOR;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.station.StationCode;
import edu.sc.seis.sod.subsetter.station.StationOR;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class NetworkQueryConstraints {
    List<String> constrainingNetworkCodes = new ArrayList<String>();
    List<String> constrainingStationCodes = new ArrayList<String>();
    List<String> constrainingLocationCodes = new ArrayList<String>();
    List<String> constrainingChannelCodes = new ArrayList<String>();
    MicroSecondDate beginConstraint;
    MicroSecondDate endConstraint;

    public NetworkQueryConstraints(List<String> constrainingNetworkCodes, List<String> constrainingStationCodes, List<String> constrainingLocationCodes, List<String> constrainingChannelCodes) {
        this.constrainingNetworkCodes = constrainingNetworkCodes;
        this.constrainingStationCodes = constrainingStationCodes;
        this.constrainingLocationCodes = constrainingLocationCodes;
        this.constrainingChannelCodes = constrainingChannelCodes;
    }

    public NetworkQueryConstraints(NetworkSubsetter attrSubsetter, StationSubsetter stationSubsetter, List<ChannelSubsetter> channelSubsetterList, TimeRange timeRange) {
        List<Subsetter> kids;
        Object kids2;
        if (timeRange != null) {
            this.beginConstraint = new MicroSecondDate(timeRange.start_time);
            this.endConstraint = new MicroSecondDate(timeRange.end_time);
            if (this.endConstraint.after((Date)ClockUtil.now().subtract(new TimeInterval(1.0, UnitImpl.HOUR)))) {
                this.endConstraint = null;
            }
        }
        this.constrainingNetworkCodes = new ArrayList<String>();
        if (attrSubsetter != null) {
            if (attrSubsetter instanceof NetworkOR) {
                kids2 = ((NetworkOR)attrSubsetter).getNetworkSubsetters();
                for (int i = 0; i < ((NetworkSubsetter[])kids2).length; ++i) {
                    if (!(kids2[i] instanceof NetworkCode)) {
                        this.constrainingNetworkCodes.clear();
                        break;
                    }
                    this.constrainingNetworkCodes.add(((NetworkCode)kids2[i]).getCode());
                }
            } else if (attrSubsetter instanceof NetworkCode) {
                this.constrainingNetworkCodes.add(((NetworkCode)attrSubsetter).getCode());
            }
        }
        this.constrainingStationCodes = new ArrayList<String>();
        if (stationSubsetter != null) {
            if (stationSubsetter instanceof StationOR) {
                kids2 = ((StationOR)stationSubsetter).getSubsetters();
                Iterator i = kids2.iterator();
                while (i.hasNext()) {
                    Subsetter subsetter = (Subsetter)i.next();
                    if (subsetter instanceof StationCode) {
                        this.constrainingStationCodes.add(((StationCode)subsetter).getCode());
                        continue;
                    }
                    this.constrainingStationCodes.clear();
                    break;
                }
            } else if (stationSubsetter instanceof StationCode) {
                this.constrainingStationCodes.add(((StationCode)stationSubsetter).getCode());
            }
        }
        this.constrainingChannelCodes = new ArrayList<String>();
        this.constrainingLocationCodes = new ArrayList<String>();
        ArrayList<ChannelSubsetter> onlySiteList = new ArrayList<ChannelSubsetter>();
        ArrayList<ChannelSubsetter> onlyChanList = new ArrayList<ChannelSubsetter>();
        Iterator<ChannelSubsetter> it = channelSubsetterList.iterator();
        boolean secondMightBeChan = false;
        if (it.hasNext()) {
            List<Subsetter> chanOrList;
            ChannelSubsetter first = it.next();
            if (first instanceof ChannelOR) {
                boolean isAllChannelCode = true;
                boolean isAllSiteCode = true;
                chanOrList = ((ChannelOR)first).getSubsetters();
                for (Subsetter subsetter2 : chanOrList) {
                    if (subsetter2 instanceof ChannelCode) {
                        isAllSiteCode = false;
                        continue;
                    }
                    if (subsetter2 instanceof SiteCode) {
                        isAllChannelCode = false;
                        continue;
                    }
                    isAllChannelCode = false;
                    isAllSiteCode = false;
                    break;
                }
                if (isAllSiteCode) {
                    onlySiteList.add(first);
                    secondMightBeChan = true;
                }
                if (isAllChannelCode) {
                    onlyChanList.add(first);
                }
            } else if (first instanceof SiteCode) {
                onlySiteList.add(first);
                secondMightBeChan = true;
            } else if (first instanceof ChannelCode) {
                onlyChanList.add(first);
            }
            if (it.hasNext() && secondMightBeChan) {
                ChannelSubsetter second = it.next();
                if (second instanceof ChannelOR) {
                    boolean isAllChannelCode = true;
                    chanOrList = ((ChannelOR)second).getSubsetters();
                    for (Subsetter subsetter2 : chanOrList) {
                        if (subsetter2 instanceof ChannelCode) continue;
                        isAllChannelCode = false;
                        break;
                    }
                    if (isAllChannelCode) {
                        onlyChanList.add(second);
                    }
                } else if (second instanceof ChannelCode) {
                    onlyChanList.add(second);
                }
            }
        }
        if (onlyChanList.size() != 0 && onlyChanList.size() <= 1) {
            if (onlyChanList.size() == 1 && onlyChanList.get(0) instanceof ChannelOR) {
                kids = ((ChannelOR)onlyChanList.get(0)).getSubsetters();
                for (Subsetter subsetter : kids) {
                    if (subsetter instanceof ChannelCode) {
                        this.constrainingChannelCodes.add(((ChannelCode)subsetter).getCode());
                        continue;
                    }
                    this.constrainingChannelCodes.clear();
                    break;
                }
            } else if (onlyChanList.size() == 1 && onlyChanList.get(0) instanceof ChannelCode) {
                this.constrainingChannelCodes.add(((ChannelCode)onlyChanList.get(0)).getCode());
            }
        }
        if (onlySiteList.size() != 0 && onlySiteList.size() <= 1) {
            if (onlySiteList.size() == 1 && onlySiteList.get(0) instanceof ChannelOR) {
                kids = ((ChannelOR)onlySiteList.get(0)).getSubsetters();
                for (Subsetter subsetter : kids) {
                    if (subsetter instanceof SiteCode) {
                        this.constrainingLocationCodes.add(((SiteCode)subsetter).getCode());
                        continue;
                    }
                    this.constrainingLocationCodes.clear();
                    break;
                }
            } else if (onlySiteList.size() == 1 && onlySiteList.get(0) instanceof SiteCode) {
                this.constrainingLocationCodes.add(((SiteCode)onlySiteList.get(0)).getCode());
            }
        }
    }

    public List<String> getConstrainingNetworkCodes() {
        return this.constrainingNetworkCodes;
    }

    public List<String> getConstrainingStationCodes() {
        return this.constrainingStationCodes;
    }

    public List<String> getConstrainingLocationCodes() {
        return this.constrainingLocationCodes;
    }

    public List<String> getConstrainingChannelCodes() {
        return this.constrainingChannelCodes;
    }

    public MicroSecondDate getConstrainingBeginTime() {
        return this.beginConstraint;
    }

    public MicroSecondDate getConstrainingEndTime() {
        return this.endConstraint;
    }
}

