/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.hibernate.ChannelSensitivity;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationFromDB
extends WrappingNetworkSource
implements NetworkSource {
    private static HashMap<String, String> inProgress = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationFromDB.class);

    public InstrumentationFromDB(NetworkSource wrapped) {
        super(wrapped);
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        ChannelSensitivity dbSensitivity = NetworkDB.getSingleton().getSensitivity(chan);
        if (dbSensitivity != null) {
            if (!ChannelSensitivity.isNonChannelSensitivity((ChannelSensitivity)dbSensitivity)) {
                QuantityImpl out = new QuantityImpl((double)dbSensitivity.getOverallGain(), (Unit)dbSensitivity.getInputUnits());
                return out;
            }
            throw new ChannelNotFound(chan.getId());
        }
        QuantityImpl sense = this.getWrapped().getSensitivity(chan);
        if (sense == null) {
            throw new ChannelNotFound(chan.getId());
        }
        dbSensitivity = new ChannelSensitivity(chan, (float)sense.getValue(), 0.0f, sense.getUnit());
        NetworkDB.getSingleton().putSensitivity(dbSensitivity);
        return sense;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, SodSourceException {
        Instrumentation inst;
        HashMap<String, String> hashMap;
        String key = ChannelIdUtil.toString((ChannelId)chan.getId());
        try {
            hashMap = inProgress;
            synchronized (hashMap) {
                while (inProgress.containsKey(key)) {
                    try {
                        inProgress.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                inProgress.put(key, "working");
                inProgress.notifyAll();
            }
            inst = NetworkDB.getSingleton().getInstrumentation(chan);
            if (inst != null && inst.the_response.stages.length == 0) {
                logger.warn("bad instrumentation in db, stages.length==0, regetting. " + ChannelIdUtil.toStringNoDates((Channel)chan));
                NetworkDB.getSingleton().putInstrumentation(chan, null);
                inst = null;
            }
            if (inst == null) {
                try {
                    inst = this.getWrapped().getInstrumentation(chan);
                    NetworkDB.getSingleton().putInstrumentation(chan, inst);
                }
                catch (ChannelNotFound e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putInstrumentation(chan, null);
                }
                catch (InvalidResponse e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putInstrumentation(chan, null);
                }
                catch (SodSourceException e) {
                    logger.warn("exception", (Throwable)e);
                    NetworkDB.getSingleton().putInstrumentation(chan, null);
                }
            }
        }
        finally {
            hashMap = inProgress;
            synchronized (hashMap) {
                inProgress.remove(key);
                inProgress.notifyAll();
            }
        }
        return inst;
    }
}

