/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CombineNetworkSource
extends AbstractNetworkSource
implements NetworkSource {
    List<NetworkSource> wrapped;
    HashMap<String, NetworkSource> codeToSource = new HashMap();

    public CombineNetworkSource(Element config) throws ConfigurationException {
        super(config);
        this.wrapped = new ArrayList<NetworkSource>();
        NodeList children = config.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element el = (Element)node;
            this.wrapped.add((NetworkSource)SodUtil.load(el, new String[]{"network"}));
        }
    }

    @Override
    public String getName() {
        String out = this.getClass().getSimpleName() + "[";
        for (NetworkSource source : this.wrapped) {
            out = out + source.getName() + ", ";
        }
        return out.substring(0, out.length() - 2) + "]";
    }

    @Override
    public TimeInterval getRefreshInterval() {
        TimeInterval out = new TimeInterval(-1.0, UnitImpl.MILLISECOND);
        for (NetworkSource source : this.wrapped) {
            if (!(out.getValue() < 0.0) && !out.greaterThan((QuantityImpl)source.getRefreshInterval())) continue;
            out = source.getRefreshInterval();
        }
        return out;
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        NetworkSource source;
        String code = NetworkIdUtil.toStringNoDates((NetworkAttr)attr);
        try {
            source = this.getSourceForCode(code);
        }
        catch (SodSourceException e) {
            throw new RuntimeException("Network not found: " + NetworkIdUtil.toString((NetworkAttr)attr));
        }
        return source.getNetwork(attr);
    }

    @Override
    public List<? extends CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        for (NetworkSource source : this.wrapped) {
            List<? extends CacheNetworkAccess> out = source.getNetworkByName(name);
            if (out == null || out.size() == 0) continue;
            return out;
        }
        return new ArrayList();
    }

    @Override
    public synchronized List<? extends NetworkAttrImpl> getNetworks() throws SodSourceException {
        ArrayList<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
        for (NetworkSource source : this.wrapped) {
            List<? extends NetworkAttrImpl> subOut = source.getNetworks();
            if (subOut == null) continue;
            for (NetworkAttrImpl networkAttrImpl : subOut) {
                String code = NetworkIdUtil.toStringNoDates((NetworkAttr)networkAttrImpl);
                if (this.codeToSource.containsKey(code)) continue;
                this.codeToSource.put(code, source);
                out.add(networkAttrImpl);
            }
        }
        return out;
    }

    @Override
    public List<? extends StationImpl> getStations(NetworkAttrImpl net) throws SodSourceException {
        NetworkSource source = this.getSourceForCode(NetworkIdUtil.toStringNoDates((NetworkAttr)net));
        if (source != null) {
            return source.getStations(net);
        }
        return new ArrayList();
    }

    @Override
    public List<? extends ChannelImpl> getChannels(StationImpl station) throws SodSourceException {
        NetworkSource source = this.getSourceForCode(NetworkIdUtil.toStringNoDates((NetworkId)station.getId().network_id));
        if (source != null) {
            return source.getChannels(station);
        }
        return new ArrayList();
    }

    @Override
    public QuantityImpl getSensitivity(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        QuantityImpl out;
        NetworkSource source = this.getSourceForCode(NetworkIdUtil.toStringNoDates((NetworkId)chan.getId().network_id));
        if (source != null && (out = source.getSensitivity(chan)) != null) {
            return out;
        }
        throw new ChannelNotFound();
    }

    @Override
    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound, InvalidResponse, SodSourceException {
        Instrumentation out;
        NetworkSource source = this.getSourceForCode(NetworkIdUtil.toStringNoDates((NetworkId)chan.getId().network_id));
        if (source != null && (out = source.getInstrumentation(chan)) != null) {
            return out;
        }
        throw new ChannelNotFound();
    }

    synchronized NetworkSource getSourceForCode(String code) throws SodSourceException {
        if (this.codeToSource.containsKey(code)) {
            return this.codeToSource.get(code);
        }
        for (NetworkSource source : this.wrapped) {
            List<? extends NetworkAttrImpl> sublist = source.getNetworks();
            for (NetworkAttrImpl networkAttrImpl : sublist) {
                if (!code.equals(NetworkIdUtil.toStringNoDates((NetworkId)networkAttrImpl.get_id()))) continue;
                this.codeToSource.put(code, source);
                return source;
            }
        }
        return null;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
        for (NetworkSource source : this.wrapped) {
            source.setConstraints(constraints);
        }
    }
}

