/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockEventAttr;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockOrigin;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.AbstractSource;
import edu.sc.seis.sod.source.event.EventSource;
import java.util.Date;
import org.w3c.dom.Element;

public class PeriodicFakeEventSource
extends AbstractSource
implements EventSource {
    MicroSecondDate startTime;
    TimeInterval interval;
    MicroSecondDate nextEventTime;
    MicroSecondDate prevEventTime = null;
    int numEvents = -1;
    int eventCounter = 0;
    static Magnitude[] mags = new Magnitude[]{new Magnitude("FAKE", -10.0f, "nobody")};

    protected PeriodicFakeEventSource(MicroSecondDate startTime, TimeInterval interval, int numEvents) {
        super("PeriodicFakeEventSource");
        this.startTime = startTime;
        this.interval = interval;
        this.numEvents = numEvents;
        this.nextEventTime = startTime;
    }

    public PeriodicFakeEventSource(Element config) throws ConfigurationException {
        super(config, "PeriodicFakeEventSource ");
        this.startTime = SodUtil.loadTime(SodUtil.getElement(config, "startTime")).load();
        this.interval = SodUtil.loadTimeInterval(SodUtil.getElement(config, "interval"));
        this.numEvents = SodUtil.loadInt(config, "numEvents", -1);
        this.nextEventTime = this.startTime;
    }

    @Override
    public String getDescription() {
        return "Periodic Fake Events " + this.numEvents + " events from " + this.startTime + " in steps of " + this.interval;
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        if (this.numEvents != -1) {
            return new MicroSecondTimeRange(this.startTime, (TimeInterval)this.interval.multiplyBy((double)(this.numEvents - 1)));
        }
        return new MicroSecondTimeRange(this.startTime, ClockUtil.wayFuture());
    }

    @Override
    public TimeInterval getWaitBeforeNext() {
        if (this.nextEventTime.before((Date)ClockUtil.now())) {
            return new TimeInterval(0.0, UnitImpl.SECOND);
        }
        return this.nextEventTime.subtract(ClockUtil.now());
    }

    @Override
    public boolean hasNext() {
        return this.numEvents == -1 || this.eventCounter < this.numEvents;
    }

    @Override
    public CacheEvent[] next() {
        if (this.nextEventTime.before((Date)ClockUtil.now())) {
            ++this.eventCounter;
            this.prevEventTime = this.nextEventTime;
            this.nextEventTime = this.startTime.add((TimeInterval)this.interval.multiplyBy((double)this.eventCounter));
            return new CacheEvent[]{new CacheEvent(MockEventAttr.create((int)-1), MockOrigin.create((MicroSecondDate)this.prevEventTime, (Magnitude[])mags))};
        }
        return new CacheEvent[0];
    }
}

