/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import de.erichseifert.gral.data.AbstractDataSource;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;

class SeisPlotDataSource
extends AbstractDataSource {
    LocalSeismogramImpl seisX;
    LocalSeismogramImpl seisY;
    float xAz;
    float yAz;
    MicroSecondTimeRange timeWindow;

    SeisPlotDataSource(LocalSeismogramImpl seisX, float xAz, LocalSeismogramImpl seisY, float yAz) {
        super(new Class[]{Float.class, Float.class});
        assert (seisX.getNumPoints() == seisY.getNumPoints());
        this.seisX = seisX;
        this.seisY = seisY;
        this.xAz = xAz;
        this.yAz = yAz;
        if ((double)Math.abs((yAz - 90.0f) % 360.0f - xAz % 360.0f) < 0.1) {
            this.seisY = seisX;
            this.seisX = seisY;
            this.yAz = xAz;
            this.xAz = yAz;
        }
    }

    public Comparable<?> get(int col, int row) {
        try {
            double rot = Math.toRadians(90.0f - this.xAz);
            if (col == 0) {
                return Float.valueOf((float)(Math.cos(rot) * (double)this.seisX.get_as_floats()[row] - Math.sin(rot) * (double)this.seisY.get_as_floats()[row]));
            }
            return Float.valueOf((float)(Math.sin(rot) * (double)this.seisX.get_as_floats()[row] + Math.cos(rot) * (double)this.seisY.get_as_floats()[row]));
        }
        catch (FissuresException e) {
            throw new RuntimeException("Should not happen, but I guess it did", e);
        }
    }

    public int getRowCount() {
        return this.seisX.getNumPoints();
    }
}

