/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.model.ISOTime;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeSimpleDateFormat;
import edu.sc.seis.fissuresUtil.display.configuration.BorderConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.BorderTitleConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.SeismogramDisplayConfiguration;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.velocity.ContextWrangler;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.velocity.VelocityContext;

public class SeismogramTitler {
    private ThreadSafeSimpleDateFormat df = new ThreadSafeSimpleDateFormat("yyyy-MM-dd HH:mm:ss z", ISOTime.UTC);
    private SimpleVelocitizer sv;
    private String[] titleFormatStrings;
    private BorderConfiguration titleBorder;

    public SeismogramTitler(BorderConfiguration titleBorder) {
        this.titleBorder = titleBorder;
        this.sv = new SimpleVelocitizer();
        BorderTitleConfiguration[] titles = titleBorder.getTitles();
        this.titleFormatStrings = new String[titles.length];
        for (int i = 0; i < titles.length; ++i) {
            this.titleFormatStrings[i] = titles[i].getTitle();
        }
    }

    public void title(EventAccessOperations event, Channel channel, MicroSecondTimeRange timeRange) {
        this.title(event, channel, timeRange, null);
    }

    public void title(EventAccessOperations event, Channel channel, MicroSecondTimeRange timeRange, Map<String, Object> extras) {
        VelocityContext vc = ContextWrangler.createContext(channel);
        ContextWrangler.insertIntoContext(channel, vc);
        ContextWrangler.insertIntoContext(event, vc);
        vc.put("beginTime", (Object)this.df.format((Date)timeRange.getBeginTime()));
        vc.put("endTime", (Object)this.df.format((Date)timeRange.getEndTime()));
        if (extras != null) {
            for (String key : extras.keySet()) {
                vc.put(key, extras.get(key));
            }
        }
        BorderTitleConfiguration[] titles = this.titleBorder.getTitles();
        for (int j = 0; j < titles.length; ++j) {
            titles[j].setText(this.sv.evaluate(this.titleFormatStrings[j], vc));
        }
    }

    public static BorderConfiguration[] extractBorderConfigs(SeismogramDisplayConfiguration[] sdcs) {
        ArrayList<BorderConfiguration[]> borderConfigs = new ArrayList<BorderConfiguration[]>();
        for (int i = 0; i < sdcs.length; ++i) {
            borderConfigs.add(sdcs[i].getBorders());
        }
        return borderConfigs.toArray(new BorderConfiguration[0]);
    }
}

