/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_SetSac;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import edu.sc.seis.sod.process.waveform.SacProcess;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class PhaseHeaderProcess
implements SacProcess {
    private static final int DEFAULT_T_HEADER = 0;
    private static final String DEFAULT_MODEL = "prem";
    private static final String DEFAULT_PHASE = "ttp";
    String model;
    String phaseName;
    int tHeader;
    int arrivalIndex = 0;
    private static final Logger logger = LoggerFactory.getLogger(PhaseHeaderProcess.class);

    public PhaseHeaderProcess(String model, String phaseName, int tHeader, int arrivalIndex) {
        this.model = model;
        this.phaseName = phaseName;
        this.tHeader = tHeader;
        this.arrivalIndex = arrivalIndex;
        if (this.arrivalIndex > 0) {
            --this.arrivalIndex;
        }
    }

    public PhaseHeaderProcess(Element phaseEl) {
        this.model = DOMHelper.extractText((Element)phaseEl, (String)"model", (String)DEFAULT_MODEL);
        this.phaseName = DOMHelper.extractText((Element)phaseEl, (String)"phaseName", (String)DEFAULT_PHASE);
        String header = DOMHelper.extractText((Element)phaseEl, (String)"tHeader", (String)"0");
        this.tHeader = header.equalsIgnoreCase("a") ? 10 : DOMHelper.extractInt((Element)phaseEl, (String)"tHeader", (int)0);
        this.arrivalIndex = DOMHelper.extractInt((Element)phaseEl, (String)"arrivalIndex", (int)1);
        if (this.arrivalIndex > 0) {
            --this.arrivalIndex;
        }
    }

    @Override
    public void process(SacTimeSeries sac, CacheEvent event, ChannelImpl channel) {
        try {
            List arrivals = TauPUtil.getTauPUtil((String)this.model).calcTravelTimes(channel.getSite().getLocation(), (Origin)EventUtil.extractOrigin((EventAccessOperations)event), new String[]{this.phaseName});
            if (this.arrivalIndex >= 0 && arrivals.size() > this.arrivalIndex) {
                TauP_SetSac.setSacTHeader((SacTimeSeries)sac, (int)this.tHeader, (Arrival)((Arrival)arrivals.get(this.arrivalIndex)));
            } else if (this.arrivalIndex < 0 && arrivals.size() > -1 * this.arrivalIndex) {
                TauP_SetSac.setSacTHeader((SacTimeSeries)sac, (int)this.tHeader, (Arrival)((Arrival)arrivals.get(arrivals.size() + this.arrivalIndex)));
            }
        }
        catch (TauModelException e) {
            logger.warn("Problem setting travel times for " + this.phaseName + " in " + this.model, (Throwable)e);
        }
    }
}

