/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeBranch;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataLogicalSubsetter;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForkProcess
implements WaveformProcess,
Threadable {
    public static final List<String> packages = new LinkedList<String>();
    protected List localSeisProcessList = new ArrayList();

    public ForkProcess(Element config) throws ConfigurationException {
        NodeList children = config.getChildNodes();
        String[] packageArray = packages.toArray(new String[0]);
        for (int i = 0; i < children.getLength(); ++i) {
            Object sodElement;
            Node node = children.item(i);
            if (!(node instanceof Element) || !((sodElement = SodUtil.load((Element)node, packageArray)) instanceof Subsetter)) continue;
            this.localSeisProcessList.add(ForkProcess.createSubsetter((Subsetter)sodElement));
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    public static WaveformProcess createSubsetter(Subsetter s) throws ConfigurationException {
        if (s instanceof WaveformProcess) {
            return (WaveformProcess)s;
        }
        final AvailableDataSubsetter subsetter = AvailableDataLogicalSubsetter.createSubsetter(s);
        return new WaveformProcess(){

            @Override
            public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
                return new WaveformResult(seismograms, subsetter.accept(event, channel, request, available, cookieJar));
            }
        };
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] request, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        return new WaveformResult(ForkProcess.copySeismograms(seismograms), this.doAND(event, channel, request, available, seismograms, cookieJar).getReason());
    }

    protected WaveformResult doAND(CacheEvent event, ChannelImpl channel, RequestFilter[] request, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        ArrayList<StringTree> reasons = new ArrayList<StringTree>(this.localSeisProcessList.size());
        Iterator it = this.localSeisProcessList.iterator();
        WaveformResult result = new WaveformResult(seismograms, new StringTreeLeaf(this, true));
        while (it.hasNext() && result.isSuccess()) {
            WaveformProcess processor = (WaveformProcess)it.next();
            result = LocalSeismogramArm.runProcessorThreadCheck(processor, event, channel, request, available, result.getSeismograms(), cookieJar);
            reasons.add(result.getReason());
        }
        return new WaveformResult(result.getSeismograms(), new StringTreeBranch((Object)this, result.isSuccess(), reasons.toArray(new StringTree[0])));
    }

    public static LocalSeismogramImpl[] copySeismograms(LocalSeismogramImpl[] seismograms) {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = new LocalSeismogramImpl((SeismogramAttr)seismograms[i], seismograms[i].data);
        }
        return out;
    }

    public String toString() {
        String s = SodUtil.getSimpleName(this.getClass()) + "(";
        Iterator it = this.localSeisProcessList.iterator();
        while (it.hasNext()) {
            s = s + it.next().toString() + ",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + ")";
        return s;
    }

    public WaveformProcess[] getWrappedProcessors() {
        return this.localSeisProcessList.toArray(new WaveformProcess[0]);
    }

    static {
        packages.add("waveform");
        packages.addAll(AvailableDataLogicalSubsetter.packages);
    }
}

