/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.hibernate.ChannelSensitivity;
import edu.sc.seis.fissuresUtil.hibernate.InstrumentationBlob;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.CommonAccess;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.LoadedNetworkSource;
import edu.sc.seis.sod.source.network.NetworkFinder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import org.omg.CORBA_2_3.ORB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshNetworkArm
extends TimerTask {
    private List<Integer> networksBeingReloaded = new ArrayList<Integer>();
    private List<Integer> stationsBeingReloaded = new ArrayList<Integer>();
    NetworkArm netArm;
    private static final Logger logger = LoggerFactory.getLogger(RefreshNetworkArm.class);

    public RefreshNetworkArm(NetworkArm netArm) {
        this.netArm = netArm;
        InstrumentationBlob.setORB((ORB)CommonAccess.getORB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Refreshing Network Arm");
        try {
            LinkedList<NetworkAttrImpl> needReload = new LinkedList<NetworkAttrImpl>();
            RefreshNetworkArm refreshNetworkArm = this;
            synchronized (refreshNetworkArm) {
                List<NetworkAttrImpl> nets;
                if (this.netArm.getInternalNetworkSource() instanceof NetworkFinder) {
                    ((NetworkFinder)this.netArm.getInternalNetworkSource()).reset();
                }
                if ((nets = this.netArm.getSuccessfulNetworksFromServer()).size() == 0) {
                    return;
                }
                for (NetworkAttrImpl net : nets) {
                    if (!this.isNetworkBeingReloaded(net.getDbid())) {
                        this.networksBeingReloaded.add(new Integer(net.getDbid()));
                        needReload.add(net);
                        logger.debug("Will Reload " + NetworkIdUtil.toString((NetworkAttr)net));
                        continue;
                    }
                    logger.info("net already in processing list, skipping..." + NetworkIdUtil.toString((NetworkAttr)net));
                }
            }
            for (NetworkAttrImpl cacheNetwork : needReload) {
                NetworkDB.getSingleton().put(cacheNetwork);
            }
            NetworkDB.commit();
            while (needReload.size() != 0) {
                Iterator it = needReload.iterator();
                while (it.hasNext()) {
                    NetworkAttrImpl net = (NetworkAttrImpl)it.next();
                    if (this.processNetwork(net)) {
                        RefreshNetworkArm refreshNetworkArm2 = this;
                        synchronized (refreshNetworkArm2) {
                            this.networksBeingReloaded.remove(new Integer(net.getDbid()));
                            it.remove();
                            logger.debug("Successful reload of " + NetworkIdUtil.toStringNoDates((NetworkAttr)net));
                            this.notifyAll();
                            if (Start.getWaveformRecipe() != null) {
                                this.wait(10L);
                            }
                            continue;
                        }
                    }
                    logger.debug("reload not successful, will do again " + NetworkIdUtil.toStringNoDates((NetworkAttr)net));
                }
                Thread.sleep(1000L);
            }
            this.netArm.finish();
        }
        catch (Throwable t) {
            Start.armFailure(this.netArm, t);
            GlobalExceptionHandler.handle((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNetwork(NetworkAttrImpl net) {
        logger.debug("refresh " + NetworkIdUtil.toString((NetworkAttr)net));
        try {
            StationImpl[] stas = this.netArm.getSuccessfulStationsFromServer(net);
            ArrayList<StationImpl> allStations = new ArrayList<StationImpl>();
            for (int s = 0; s < stas.length; ++s) {
                allStations.add(stas[s]);
            }
            RefreshNetworkArm s = this;
            synchronized (s) {
                for (int s2 = 0; s2 < stas.length; ++s2) {
                    this.stationsBeingReloaded.add(stas[s2].getDbid());
                }
            }
            logger.info("found " + stas.length + " stations in " + NetworkIdUtil.toString((NetworkAttr)net));
            if (Start.getWaveformRecipe() != null || this.netArm.getChannelSubsetters().size() != 0) {
                for (int s3 = 0; s3 < stas.length; ++s3) {
                    LoadedNetworkSource loadSource = new LoadedNetworkSource(this.netArm.getInternalNetworkSource(), allStations, stas[s3]);
                    this.processStation(loadSource, stas[s3]);
                    RefreshNetworkArm refreshNetworkArm = this;
                    synchronized (refreshNetworkArm) {
                        this.stationsBeingReloaded.remove(new Integer(stas[s3].getDbid()));
                        continue;
                    }
                }
            } else {
                logger.info("Not loading channels as no waveformArm or channel subsetters");
            }
            NetworkDB.commit();
            return true;
        }
        catch (Throwable t) {
            NetworkDB.rollback();
            String netstr = "unknown";
            try {
                netstr = NetworkIdUtil.toString((NetworkAttr)net);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            GlobalExceptionHandler.handle((String)("Problem with network: " + netstr), (Throwable)t);
            return false;
        }
    }

    void processStation(LoadedNetworkSource loadSource, StationImpl sta) {
        if (Start.getWaveformRecipe() instanceof MotionVectorArm) {
            List<ChannelGroup> list = this.netArm.getSuccessfulChannelGroupsFromServer(sta, loadSource);
        } else {
            List<ChannelImpl> list = this.netArm.getSuccessfulChannelsFromServer(sta, loadSource);
        }
    }

    void checkSensitivityLoaded(ChannelGroup cg, LoadedNetworkSource loadSource) {
        this.checkSensitivityLoaded(cg.getChannel1(), loadSource);
        this.checkSensitivityLoaded(cg.getChannel2(), loadSource);
        this.checkSensitivityLoaded(cg.getChannel3(), loadSource);
    }

    void checkSensitivityLoaded(ChannelImpl chan, LoadedNetworkSource loadSource) {
        try {
            QuantityImpl quantityImpl = loadSource.getSensitivity(chan);
        }
        catch (SodSourceException e) {
            logger.warn("Error getting Instrumentation for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()));
            NetworkDB.getSingleton().putSensitivity(ChannelSensitivity.createNonChannelSensitivity((ChannelImpl)chan));
        }
        catch (ChannelNotFound e) {
            logger.warn("No Instrumentation for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()));
            NetworkDB.getSingleton().putSensitivity(ChannelSensitivity.createNonChannelSensitivity((ChannelImpl)chan));
        }
        catch (InvalidResponse e) {
            logger.warn("Invalid Instrumentation for " + ChannelIdUtil.toStringFormatDates((ChannelId)chan.getId()));
            NetworkDB.getSingleton().putSensitivity(ChannelSensitivity.createNonChannelSensitivity((ChannelImpl)chan));
        }
    }

    public synchronized boolean isNetworkBeingReloaded(int dbid) {
        if (dbid == 0) {
            throw new IllegalArgumentException("dbid = 0 is not legal, Network must not be in db yet");
        }
        return this.networksBeingReloaded.contains(new Integer(dbid));
    }

    public synchronized boolean isStationBeingReloaded(int dbid) {
        if (dbid == 0) {
            throw new IllegalArgumentException("dbid = 0 is not legal, Station must not be in db yet");
        }
        return this.stationsBeingReloaded.contains(new Integer(dbid));
    }
}

