/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.AbstractEventPair;
import edu.sc.seis.sod.CookieEventPair;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.EventChannelPair;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStationPair
extends CookieEventPair {
    private StationImpl station;
    private static final Logger logger = LoggerFactory.getLogger(EventStationPair.class);

    protected EventStationPair() {
    }

    public EventStationPair(StatefulEvent event, StationImpl station) {
        this(event, station, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
    }

    public EventStationPair(StatefulEvent event, StationImpl station, Status status) {
        super(event, status);
        this.setStation(station);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SodDB sodDb = SodDB.getSingleton();
        logger.debug("Begin EventStationPair (e=" + this.getEvent().getDbid() + ",s=" + this.getStationDbId() + ") " + this);
        Location l = this.getEvent().getOrigin().getLocation();
        l = this.getStation().getLocation();
        try {
            AbstractEventChannelPair p;
            EventEffectiveTimeOverlap overlap = new EventEffectiveTimeOverlap(this.getEvent());
            HashMap<String, Serializable> cookies = new HashMap<String, Serializable>();
            StringTree accepted = new StringTreeLeaf(this, false);
            try {
                EventStationSubsetter esSub = Start.getWaveformRecipe().getEventStationSubsetter();
                EventStationSubsetter eventStationSubsetter = esSub;
                synchronized (eventStationSubsetter) {
                    accepted = esSub.accept(this.getEvent(), this.getStation(), new CookieJar(this, cookies));
                }
            }
            catch (Throwable e) {
                if (e instanceof SystemException) {
                    this.update(e, Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.CORBA_FAILURE));
                    this.updateRetries();
                    failLogger.info("Network or server problem, SOD will continue to retry this item periodically: (" + e.getClass().getName() + ") " + this);
                    logger.debug(this.toString(), e);
                } else {
                    this.update(e, Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.SYSTEM_FAILURE));
                    failLogger.warn(this.toString(), e);
                }
                SodDB.commit();
                logger.debug("Finish (fail) EStaP: " + this);
                SodDB.commit();
                return;
            }
            if (!accepted.isSuccess()) {
                this.update(Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.REJECT));
                SodDB.commit();
                failLogger.info(this + "  " + accepted.toString());
                return;
            }
            SodDB.commit();
            SodDB.getSession().update((Object)this);
            ArrayList<EventChannelPair> chanPairs = new ArrayList<EventChannelPair>();
            if (Start.getWaveformRecipe() instanceof MotionVectorArm) {
                List<ChannelGroup> chanGroups = Start.getNetworkArm().getSuccessfulChannelGroups(this.getStation());
                if (chanGroups.size() == 0) {
                    logger.info("No successful channel groups for " + this);
                }
                ArrayList<ChannelGroup> arrayList = new ArrayList<ChannelGroup>();
                for (ChannelGroup channelGroup : chanGroups) {
                    if (overlap.overlaps((Channel)channelGroup.getChannels()[0])) {
                        arrayList.add(channelGroup);
                        continue;
                    }
                    failLogger.info(ChannelIdUtil.toString((ChannelId)channelGroup.getChannels()[0].get_id()) + "'s channel effective time does not overlap the event time");
                }
                for (ChannelGroup channelGroup : arrayList) {
                    logger.debug("Put EventVectorPair (" + this.getEventDbId() + ", cg " + channelGroup.getDbid() + " (" + channelGroup.getChannel1().getDbid() + " " + channelGroup.getChannel2().getDbid() + " " + channelGroup.getChannel3().getDbid());
                    p = new EventVectorPair(this.getEvent(), channelGroup, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG), this);
                    chanPairs.add((EventChannelPair)p);
                    sodDb.put((EventVectorPair)p);
                }
            } else {
                List<ChannelImpl> channels = Start.getNetworkArm().getSuccessfulChannels(this.getStation());
                if (channels.size() == 0) {
                    logger.info("No successful channels for " + this);
                }
                ArrayList<ChannelImpl> arrayList = new ArrayList<ChannelImpl>();
                for (ChannelImpl channelImpl : channels) {
                    if (overlap.overlaps((Channel)channelImpl)) {
                        arrayList.add(channelImpl);
                    } else {
                        failLogger.info(ChannelIdUtil.toString((ChannelId)channelImpl.getId()) + "'s channel effective time does not overlap the event time");
                    }
                    logger.info(ChannelIdUtil.toString((ChannelId)channelImpl.getId()) + "' passed");
                }
                for (ChannelImpl channelImpl : arrayList) {
                    p = sodDb.createEventChannelPair(this.getEvent(), channelImpl, this);
                    p.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                    chanPairs.add((EventChannelPair)p);
                }
            }
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
            SodDB.commit();
            for (AbstractEventPair abstractEventPair : chanPairs) {
                SodDB.getSession().update((Object)abstractEventPair);
                SodDB.getSession().update((Object)this);
                abstractEventPair.run();
                SodDB.commit();
            }
            logger.debug("End EventStationPair (e=" + this.getEvent().getDbid() + ",s=" + this.getStationDbId() + ") " + this);
        }
        catch (NoPreferredOrigin e) {
            GlobalExceptionHandler.handle((Throwable)e);
            SodDB.getSession().update((Object)this);
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
            SodDB.commit();
            return;
        }
        finally {
            SodDB.commit();
        }
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().setStatus(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventStationPair)) {
            return false;
        }
        EventStationPair ecp = (EventStationPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getStationDbId() == this.getStationDbId();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getStationDbId();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        return "EventStationPair: (" + this.getDbid() + " -> " + this.getEvent().getDbid() + "," + this.getStationDbId() + ") " + (Object)((Object)this.getEvent()) + " " + StationIdUtil.toStringFormatDates((Station)this.getStation()) + " " + this.getStatus();
    }

    public int getStationDbId() {
        return this.station.getDbid();
    }

    public StationImpl getStation() {
        return this.station;
    }

    protected void setStation(StationImpl sta) {
        this.station = sta;
    }
}

