/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.sod.UserConfigurationException;
import java.util.Properties;
import org.omg.CORBA_2_3.ORB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAccess {
    private static final String NAME_SERVICE_ADDRESS = "/NameService";
    private static final String CORBALOC_DESC = "corbaloc:iiop:";
    private static ORB orb;
    private static FissuresNamingService ns;
    private static final String DMC_NSLOC = "corbaloc:iiop:dmc.iris.washington.edu:6371/NameService";
    private static String nsLoc;
    private static Logger logger;

    private CommonAccess() {
    }

    public static ClassLoader getLoader() {
        return CommonAccess.class.getClassLoader();
    }

    public static FissuresNamingService getNameService() {
        logger.info("getNameService() returnes " + ns);
        if (ns == null) {
            throw new RuntimeException("Name service is null, init has not yet been called");
        }
        return ns;
    }

    public static String getNameServiceAddress() {
        return ns.getNameServiceCorbaLoc();
    }

    public static ORB getORB() {
        return orb;
    }

    public static synchronized void initialize(Properties props, String[] args) throws UserConfigurationException {
        logger.info("CommonAccess.initialize");
        if (orb != null) {
            throw new RuntimeException("Initialize should only be called once on CommonAccess");
        }
        CommonAccess.vetNSLoc(props);
        orb = (ORB)org.omg.CORBA.ORB.init((String[])args, (Properties)props);
        logger.info("ORB class is " + orb.getClass().getName());
        new AllVTFactory().register(orb);
        ns = new FissuresNamingService(CommonAccess.getORB());
        ns.setNameServiceCorbaLoc(nsLoc);
    }

    private static void vetNSLoc(Properties props) throws UserConfigurationException {
        if (props.containsKey("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc")) {
            nsLoc = (String)props.get("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc");
        } else if (System.getProperties().containsKey("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc")) {
            nsLoc = (String)System.getProperties().get("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc");
        } else {
            logger.info("Using IRIS DMC Name service: corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
            nsLoc = DMC_NSLOC;
        }
        if (!nsLoc.startsWith(CORBALOC_DESC) || !nsLoc.endsWith(NAME_SERVICE_ADDRESS)) {
            throw new UserConfigurationException("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc must start with corbaloc:iiop: and end with /NameService but " + nsLoc + " was supplied in the properties");
        }
    }

    static {
        logger = LoggerFactory.getLogger(CommonAccess.class);
    }
}

