/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Random;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BHTree;

class BHInsertStructure {
    static boolean debug = false;
    static boolean debug2 = false;
    Random randomNumber = new Random(0L);
    ArrayList[] bhListArr = null;
    ArrayList[] oldBhListArr = null;
    BHNode[] bhListArrRef = null;
    BHNode[] oldBhListArrRef = null;
    int bhListArrCnt = 0;
    int bhListArrMaxCnt = 0;
    int blockSize = 0;

    BHInsertStructure(int n) {
        if (n > 50) {
            n = 50;
        }
        this.blockSize = 50;
        this.bhListArr = new ArrayList[n];
        this.bhListArrRef = new BHNode[n];
        this.bhListArrCnt = 0;
        this.bhListArrMaxCnt = n;
    }

    void clear() {
        int n = 0;
        while (n < this.bhListArrCnt) {
            this.bhListArr[n].clear();
            this.bhListArrRef[n] = null;
            ++n;
        }
        this.bhListArrCnt = 0;
    }

    void lookupAndInsert(BHNode bHNode, BHNode bHNode2) {
        boolean bl = false;
        int n = 0;
        while (n < this.bhListArrCnt) {
            if (this.bhListArrRef[n] == bHNode) {
                this.bhListArr[n].add(bHNode2);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            if (this.bhListArrCnt >= this.bhListArrMaxCnt) {
                if (debug) {
                    System.out.println("(1) Expanding bhListArr array ...");
                }
                this.bhListArrMaxCnt += this.blockSize;
                this.oldBhListArr = this.bhListArr;
                this.oldBhListArrRef = this.bhListArrRef;
                this.bhListArr = new ArrayList[this.bhListArrMaxCnt];
                this.bhListArrRef = new BHNode[this.bhListArrMaxCnt];
                System.arraycopy(this.oldBhListArr, 0, this.bhListArr, 0, this.oldBhListArr.length);
                System.arraycopy(this.oldBhListArrRef, 0, this.bhListArrRef, 0, this.oldBhListArrRef.length);
            }
            this.bhListArrRef[this.bhListArrCnt] = bHNode;
            this.bhListArr[this.bhListArrCnt] = new ArrayList();
            this.bhListArr[this.bhListArrCnt].add(bHNode2);
            ++this.bhListArrCnt;
        }
    }

    void updateBoundingTree(BHTree bHTree) {
        int n = 0;
        while (n < this.bhListArrCnt) {
            int n2 = 0;
            BHNode bHNode = ((BHInternalNode)this.bhListArrRef[n]).getLeftChild();
            BHNode bHNode2 = ((BHInternalNode)this.bhListArrRef[n]).getRightChild();
            if (bHNode != null) {
                ++n2;
            }
            if (bHNode2 != null) {
                ++n2;
            }
            int n3 = this.bhListArr[n].size();
            BHNode[] bHNodeArray = new BHNode[n2 + n3];
            this.bhListArr[n].toArray(bHNodeArray);
            n2 = 0;
            if (bHNode != null) {
                bHNodeArray[n3] = bHNode;
                bHNodeArray[n3 + ++n2] = bHNode2;
            }
            if (debug2 && (bHNode == null || bHNode2 == null)) {
                System.out.println("child1 or child2 is null ...");
                System.out.println("This is bad, it shouldn't happen");
            }
            ((BHInternalNode)this.bhListArrRef[n]).setRightChild(null);
            ((BHInternalNode)this.bhListArrRef[n]).setLeftChild(null);
            bHTree.cluster((BHInternalNode)this.bhListArrRef[n], bHNodeArray);
            ++n;
        }
    }
}

