/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionListener;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.HeaderPanel;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.event.MonthChangeEvent;
import net.sf.nachocalendar.event.MonthChangeListener;
import net.sf.nachocalendar.model.DataModel;

public class MonthPanel
extends JComponent {
    private int year;
    private DayPanel[][] paneles;
    private final int rows = 6;
    private final int cols = 7;
    private int tcols;
    private int firstday;
    private int showingmonth;
    private int showingyear;
    private Calendar calendar;
    private Calendar check;
    private Calendar navigation;
    private DateFormat formato;
    private String[] months;
    private String[] days;
    private HeaderPanel[] weeks;
    private Date date;
    private Collection changelisteners;
    private boolean[] workingdays;
    private DayRenderer renderer;
    private HeaderPanel[] headers;
    private boolean showWeekNumber;
    private boolean showtitle;
    private JPanel centro;
    private JLabel title;
    private Date month;
    private static final int[] MONDAYFIRST = new int[]{0, 2, 3, 4, 5, 6, 7, 1};
    private static final int[] SUNDAYFIRST = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] RESTAMONDAY = new int[]{0, 7, 1, 2, 3, 4, 5, 6};
    private int[] dayorder;
    private MouseListener mouselistener;
    private DayPanel[] daypanels;
    private ListSelectionListener listlistener;
    private int selectionOffset;
    private boolean antiAliased;
    private static final boolean[] DEFAULTWORKING = new boolean[]{false, true, true, true, true, true, true};
    private DataModel model;
    private HeaderRenderer headerRenderer;
    private EventListenerList listenerList = null;
    private transient ArrayList actionListenerList;
    static /* synthetic */ Class class$net$sf$nachocalendar$event$MonthChangeListener;

    public void setSelectionOffset(int selectionOffset) {
        this.selectionOffset = selectionOffset;
        this.repaint();
    }

    public MonthPanel() {
        this(false);
    }

    public MonthPanel(boolean showWeekNumber) {
        int i;
        this.showWeekNumber = showWeekNumber;
        this.daypanels = new DayPanel[42];
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(14, 0);
        this.check = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.check.set(10, 0);
        this.check.set(12, 0);
        this.check.set(14, 0);
        this.navigation = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.navigation.set(10, 0);
        this.navigation.set(12, 0);
        this.navigation.set(14, 0);
        this.firstday = this.calendar.getFirstDayOfWeek();
        this.setFocusable(true);
        this.dayorder = this.firstday == 2 ? MONDAYFIRST : SUNDAYFIRST;
        this.centro = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.centro, "Center");
        this.tcols = showWeekNumber ? 8 : 7;
        this.headers = new HeaderPanel[this.tcols];
        this.centro.setLayout(new GridLayout(7, this.tcols));
        this.title = new JLabel();
        this.title.setHorizontalAlignment(0);
        this.title.setVerticalAlignment(0);
        this.add((Component)this.title, "North");
        this.title.setVisible(false);
        this.changelisteners = new ArrayList();
        this.formato = DateFormat.getDateInstance(3);
        this.paneles = new DayPanel[6][7];
        this.weeks = new HeaderPanel[6];
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f == null) {
            f = new Font("Times", 0, 12);
        }
        Font ita = new Font(f.getName(), 3, f.getSize());
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.days = symbols.getShortWeekdays();
        for (i = 1; i < this.days.length; ++i) {
            this.days[i] = this.days[i].substring(0, 1).toUpperCase() + this.days[i].substring(1).toLowerCase();
        }
        this.months = symbols.getMonths();
        for (i = 0; i < this.months.length - 1; ++i) {
            this.months[i] = this.months[i].substring(0, 1).toUpperCase() + this.months[i].substring(1).toLowerCase();
        }
        for (i = 0; i < this.tcols; ++i) {
            this.headers[i] = new HeaderPanel(this.headerRenderer);
            this.centro.add(this.headers[i]);
        }
        MonthPanel mp = this;
        this.setHeaders();
        int index = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j = 0; j < this.tcols; ++j) {
                if (j == 0 && showWeekNumber) {
                    this.weeks[i2] = new HeaderPanel(this.headerRenderer);
                    this.centro.add(this.weeks[i2]);
                    this.weeks[i2].setValue(this.days[i2]);
                    continue;
                }
                int jj = j;
                if (showWeekNumber) {
                    jj = j - 1;
                }
                this.paneles[i2][jj] = new DayPanel(this.renderer, index);
                this.daypanels[index] = this.paneles[i2][jj];
                ++index;
                this.centro.add(this.paneles[i2][jj]);
            }
        }
        this.setWorkingdays(MonthPanel.getDefaultWorking());
    }

    private void setHeaders() {
        for (int i = 0; i < this.tcols; ++i) {
            if (this.showWeekNumber) {
                this.headers[i].setValue(this.days[this.dayorder[i]]);
                continue;
            }
            this.headers[i].setValue(this.days[this.dayorder[i + 1]]);
        }
    }

    public void setDay(Date d) {
        this.setDay(d, true);
    }

    public void setMonth(Date d) {
        this.setDay(d, false);
    }

    public Date getMonth() {
        return this.date;
    }

    public void showTitle(boolean show) {
        this.showtitle = show;
        this.title.setVisible(show);
        this.doLayout();
    }

    private void setDay(Date d, boolean select) {
        int i;
        this.date = d;
        boolean update = this.showingyear != this.calendar.get(1) || this.showingmonth != this.calendar.get(2);
        this.calendar.setTime(d);
        this.showingmonth = this.calendar.get(2);
        this.showingyear = this.calendar.get(1);
        this.calendar.add(6, -1 * (this.calendar.get(5) - 1));
        if (this.calendar.getFirstDayOfWeek() == 1) {
            this.calendar.add(6, -1 * (this.calendar.get(7) - 1));
        } else {
            this.calendar.add(6, -1 * (RESTAMONDAY[this.calendar.get(7)] - 1));
        }
        int week = this.calendar.get(3);
        for (i = 0; i < this.daypanels.length; ++i) {
            if (update) {
                Date temp = this.calendar.getTime();
                this.daypanels[i].setDate(temp);
                if (this.model != null) {
                    this.daypanels[i].setData(this.model.getData(temp));
                }
                if (this.calendar.get(2) == this.showingmonth) {
                    this.daypanels[i].setEnabled(true);
                } else {
                    this.daypanels[i].setEnabled(false);
                }
            }
            if (select) {
                // empty if block
            }
            this.calendar.add(6, 1);
        }
        if (this.showtitle) {
            this.title.setText(this.months[this.showingmonth] + " " + this.showingyear);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setValue(Integer.toString(week + i));
            }
        }
        this.repaint();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void refresh() {
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                if (this.model == null) continue;
                this.paneles[i][j].setData(this.model.getData(this.paneles[i][j].getDate()));
            }
        }
        this.repaint();
    }

    public Date getDay() {
        return this.date;
    }

    public Object[] getDays() {
        return null;
    }

    protected void fireChangeEvent(ChangeEvent e) {
        Iterator it = this.changelisteners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public DataModel getModel() {
        return this.model;
    }

    public void setModel(DataModel model) {
        this.model = model;
    }

    public DayRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DayRenderer renderer) {
        this.renderer = renderer;
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                this.paneles[i][j].setRenderer(renderer);
            }
        }
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        int i;
        this.headerRenderer = headerRenderer;
        for (i = 0; i < this.headers.length; ++i) {
            this.headers[i].setRenderer(headerRenderer);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setRenderer(headerRenderer);
            }
        }
    }

    public boolean[] getWorkingdays() {
        return this.workingdays;
    }

    public void setWorkingdays(boolean[] workingdays) {
        if (workingdays == null) {
            return;
        }
        this.workingdays = workingdays;
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                this.paneles[i][j].setWorking(workingdays[this.dayorder[j + 1] - 1]);
            }
        }
    }

    private boolean compareDates(Date d1, Date d2) {
        this.check.setTime(d1);
        int year = this.check.get(1);
        int month = this.check.get(2);
        int day = this.check.get(5);
        this.check.setTime(d2);
        if (day != this.check.get(5)) {
            return false;
        }
        if (month != this.check.get(2)) {
            return false;
        }
        return year == this.check.get(1);
    }

    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == 2 || firstDayOfWeek == 1) {
            this.calendar.setFirstDayOfWeek(firstDayOfWeek);
            this.check.setFirstDayOfWeek(firstDayOfWeek);
            this.dayorder = firstDayOfWeek == 1 ? SUNDAYFIRST : MONDAYFIRST;
            this.setHeaders();
            this.setMonth(this.getMonth());
        }
        this.setWorkingdays(this.getWorkingdays());
    }

    public static boolean[] getDefaultWorking() {
        return DEFAULTWORKING;
    }

    private void fireMonthChangeListenerMonthIncreased(MonthChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$net$sf$nachocalendar$event$MonthChangeListener == null ? MonthPanel.class$("net.sf.nachocalendar.event.MonthChangeListener") : class$net$sf$nachocalendar$event$MonthChangeListener)) continue;
            ((MonthChangeListener)listeners[i + 1]).monthIncreased(event);
        }
    }

    private void fireMonthChangeListenerMonthDecreased(MonthChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$net$sf$nachocalendar$event$MonthChangeListener == null ? MonthPanel.class$("net.sf.nachocalendar.event.MonthChangeListener") : class$net$sf$nachocalendar$event$MonthChangeListener)) continue;
            ((MonthChangeListener)listeners[i + 1]).monthDecreased(event);
        }
    }

    public void setEnabled(boolean b) {
        for (int i = 0; i < this.daypanels.length; ++i) {
            this.daypanels[i].setComponentEnabled(b);
        }
    }

    public boolean isEnabled() {
        return this.daypanels[0].isComponentEnabled();
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        int i;
        this.antiAliased = antiAliased;
        for (i = 0; i < this.daypanels.length; ++i) {
            this.daypanels[i].setAntiAliased(antiAliased);
        }
        for (i = 0; i < this.headers.length; ++i) {
            this.headers[i].setAntiAliased(antiAliased);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setAntiAliased(antiAliased);
            }
        }
        this.repaint();
    }

    protected DayPanel[] getDaypanels() {
        return this.daypanels;
    }

    protected void setDaypanels(DayPanel[] daypanels) {
        this.daypanels = daypanels;
    }

    public Date getMinDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        ((Calendar)cal).add(5, cal.get(5) * -1 + 1);
        return cal.getTime();
    }

    public Date getMaxDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        ((Calendar)cal).add(5, cal.get(5) * -1 + 1);
        ((Calendar)cal).add(2, 1);
        ((Calendar)cal).add(6, -1);
        return cal.getTime();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

