/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.components.MonthPanel;
import net.sf.nachocalendar.components.MonthScroller;
import net.sf.nachocalendar.components.YearScroller;
import net.sf.nachocalendar.event.DateSelectionEvent;
import net.sf.nachocalendar.event.DateSelectionListener;
import net.sf.nachocalendar.event.MonthChangeEvent;
import net.sf.nachocalendar.event.MonthChangeListener;
import net.sf.nachocalendar.event.YearChangeEvent;
import net.sf.nachocalendar.event.YearChangeListener;
import net.sf.nachocalendar.model.DataModel;
import net.sf.nachocalendar.model.DateSelectionModel;
import net.sf.nachocalendar.model.DefaultDateSelectionModel;

public class DatePanel
extends JPanel {
    private MonthPanel monthpanel;
    private Calendar calendar;
    private Calendar navigation;
    private MonthScroller monthscroller;
    private YearScroller yearscroller;
    private boolean antiAliased;
    private DateSelectionModel dateSelectionModel;
    private MouseListener mlistener;
    private KeyListener klistener;
    private transient ArrayList changeListenerList;
    private boolean[] workingDays;
    private EventListenerList listenerList = null;
    private transient ArrayList actionListenerList;
    static /* synthetic */ Class class$java$awt$event$KeyListener;
    static /* synthetic */ Class class$net$sf$nachocalendar$event$MonthChangeListener;

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        boolean old = this.antiAliased;
        this.antiAliased = antiAliased;
        this.monthpanel.setAntiAliased(antiAliased);
        this.firePropertyChange("antiAliased", old, antiAliased);
    }

    public DatePanel() {
        this.monthpanel = new MonthPanel();
        this.init();
    }

    public DatePanel(boolean showWeekNumbers) {
        this.monthpanel = new MonthPanel(showWeekNumbers);
        this.init();
    }

    private void init() {
        this.dateSelectionModel = new DefaultDateSelectionModel();
        this.monthscroller = new MonthScroller();
        this.yearscroller = new YearScroller();
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.navigation = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.add(this.monthpanel);
        this.setDate(this.calendar.getTime());
        this.setFocusable(true);
        JPanel arriba = new JPanel(new GridLayout(1, 2));
        this.setLayout(new BorderLayout());
        arriba.add(this.monthscroller);
        arriba.add(this.yearscroller);
        this.add((Component)arriba, "North");
        this.add((Component)this.monthpanel, "Center");
        this.addListeners();
        DayPanel[] daypanels = this.monthpanel.getDaypanels();
        for (int i = 0; i < daypanels.length; ++i) {
            daypanels[i].addMouseListener(this.mlistener);
            daypanels[i].addKeyListener(this.klistener);
        }
        this.monthpanel.setMonth(this.getDate());
    }

    private void addListeners() {
        this.monthscroller.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DatePanel.this.updateMonth();
            }
        });
        this.yearscroller.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DatePanel.this.updateYear();
            }
        });
        this.monthscroller.addYearChangeListener(new YearChangeListener(){

            public void yearIncreased(YearChangeEvent e) {
                DatePanel.this.yearscroller.setYear(DatePanel.this.yearscroller.getYear() + 1);
                DatePanel.this.updateYear();
            }

            public void yearDecreased(YearChangeEvent e) {
                DatePanel.this.yearscroller.setYear(DatePanel.this.yearscroller.getYear() - 1);
                DatePanel.this.updateYear();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (!DatePanel.this.isEnabled()) {
                    return;
                }
                int q = e.getWheelRotation();
                for (int i = 0; i < Math.abs(q); ++i) {
                    if (q > 0) {
                        DatePanel.this.monthscroller.nextMonth();
                        continue;
                    }
                    DatePanel.this.monthscroller.previousMonth();
                }
            }
        });
        this.dateSelectionModel.addDateSelectionListener(new DateSelectionListener(){

            public void valueChanged(DateSelectionEvent e) {
                DatePanel.this.refreshSelection();
                DatePanel.this.fireChangeListenerStateChanged(new ChangeEvent(DatePanel.this));
            }
        });
        this.mlistener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                DayPanel dp = (DayPanel)e.getSource();
                if (!dp.isEnabled() || !dp.isComponentEnabled()) {
                    return;
                }
                if (!e.isControlDown()) {
                    DatePanel.this.dateSelectionModel.clearSelection();
                    if (e.isShiftDown()) {
                        DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.dateSelectionModel.getLeadSelectionDate(), dp.getDate());
                    } else {
                        DatePanel.this.dateSelectionModel.addSelectionInterval(dp.getDate(), dp.getDate());
                    }
                } else if (e.isShiftDown()) {
                    DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.dateSelectionModel.getLeadSelectionDate(), dp.getDate());
                } else if (DatePanel.this.dateSelectionModel.isSelectedDate(dp.getDate())) {
                    DatePanel.this.dateSelectionModel.removeSelectionInterval(dp.getDate(), dp.getDate());
                } else {
                    DatePanel.this.dateSelectionModel.addSelectionInterval(dp.getDate(), dp.getDate());
                }
                DatePanel.this.dateSelectionModel.setLeadSelectionDate(dp.getDate());
                DatePanel.this.repaint();
                dp.requestFocus();
                DatePanel.this.calendar.setTime(dp.getDate());
                DatePanel.this.fireActionListenerActionPerformed(new ActionEvent(this, 0, "clicked"));
            }
        };
        this.klistener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                int month;
                boolean changed = false;
                int keycode = e.getKeyCode();
                DatePanel.this.navigation.setTime(DatePanel.this.calendar.getTime());
                if (keycode == 37 || keycode == 226) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(6, -1);
                    if (month != DatePanel.this.navigation.get(2)) {
                        DatePanel.this.fireMonthChangeListenerMonthDecreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                        DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    }
                    changed = true;
                }
                if (keycode == 39 || keycode == 227) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(6, 1);
                    if (month != DatePanel.this.navigation.get(2)) {
                        DatePanel.this.fireMonthChangeListenerMonthIncreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                        DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    }
                    changed = true;
                }
                if (keycode == 38 || keycode == 224) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(6, -7);
                    if (month != DatePanel.this.navigation.get(2)) {
                        DatePanel.this.fireMonthChangeListenerMonthDecreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                        DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    }
                    changed = true;
                }
                if (keycode == 40 || keycode == 225) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(6, 7);
                    if (month != DatePanel.this.navigation.get(2)) {
                        DatePanel.this.fireMonthChangeListenerMonthIncreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                        DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    }
                    changed = true;
                }
                if (keycode == 33) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(2, -1);
                    DatePanel.this.fireMonthChangeListenerMonthIncreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                    DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    changed = true;
                }
                if (keycode == 34) {
                    month = DatePanel.this.navigation.get(2);
                    DatePanel.this.navigation.add(2, 1);
                    DatePanel.this.fireMonthChangeListenerMonthIncreased(new MonthChangeEvent(this, DatePanel.this.navigation.getTime()));
                    DatePanel.this.setDate(DatePanel.this.navigation.getTime());
                    changed = true;
                }
                if (changed) {
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        DatePanel.this.dateSelectionModel.clearSelection();
                        if (e.isShiftDown()) {
                            DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.dateSelectionModel.getLeadSelectionDate(), DatePanel.this.navigation.getTime());
                        } else {
                            DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.navigation.getTime(), DatePanel.this.navigation.getTime());
                        }
                    } else if (e.isShiftDown()) {
                        DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.dateSelectionModel.getLeadSelectionDate(), DatePanel.this.navigation.getTime());
                    } else if (DatePanel.this.dateSelectionModel.isSelectedDate(DatePanel.this.navigation.getTime())) {
                        DatePanel.this.dateSelectionModel.removeSelectionInterval(DatePanel.this.navigation.getTime(), DatePanel.this.navigation.getTime());
                    } else {
                        DatePanel.this.dateSelectionModel.addSelectionInterval(DatePanel.this.navigation.getTime(), DatePanel.this.navigation.getTime());
                    }
                    DatePanel.this.dateSelectionModel.setLeadSelectionDate(DatePanel.this.navigation.getTime());
                    DatePanel.this.calendar.setTime(DatePanel.this.navigation.getTime());
                    DatePanel.this.monthpanel.repaint();
                }
                DatePanel.this.fireKeyListenerKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
                DatePanel.this.fireKeyListenerKeyReleased(e);
            }

            public void keyTyped(KeyEvent e) {
                DatePanel.this.fireKeyListenerKeyTyped(e);
            }
        };
    }

    private void updateMonth() {
        int month = this.calendar.get(2);
        this.calendar.add(2, this.monthscroller.getMonth() - month);
        this.monthpanel.setMonth(this.calendar.getTime());
        this.refreshSelection();
    }

    private void updateYear() {
        int year = this.calendar.get(1);
        this.calendar.add(1, this.yearscroller.getYear() - year);
        this.monthpanel.setMonth(this.calendar.getTime());
        this.refreshSelection();
    }

    public void setDate(Date d) {
        this.calendar.setTime(d);
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        boolean refresh = false;
        if (year != this.yearscroller.getYear()) {
            this.yearscroller.setYear(year);
            refresh = true;
        }
        if (month != this.monthscroller.getMonth()) {
            this.monthscroller.setMonth(month);
            refresh = true;
        }
        if (refresh) {
            this.monthpanel.setDay(d);
        }
        this.dateSelectionModel.setSelectedDate(d);
        this.refreshSelection();
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public DayRenderer getRenderer() {
        return this.monthpanel.getRenderer();
    }

    public void setRenderer(DayRenderer renderer) {
        this.monthpanel.setRenderer(renderer);
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList();
        }
        this.changeListenerList.add(listener);
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (this.changeListenerList != null) {
            this.changeListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged(ChangeEvent event) {
        ArrayList list;
        DatePanel datePanel = this;
        synchronized (datePanel) {
            if (this.changeListenerList == null) {
                return;
            }
            list = (ArrayList)this.changeListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public DataModel getModel() {
        return this.monthpanel.getModel();
    }

    public void setModel(DataModel model) {
        this.monthpanel.setModel(model);
    }

    public int getFirstDayOfWeek() {
        return this.monthpanel.getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == 2 || firstDayOfWeek == 1) {
            if (this.monthpanel.getFirstDayOfWeek() == firstDayOfWeek) {
                return;
            }
            int old = this.monthpanel.getFirstDayOfWeek();
            this.monthpanel.setFirstDayOfWeek(firstDayOfWeek);
            this.refreshSelection();
            this.repaint();
            this.firePropertyChange("firstDayOfWeek", old, firstDayOfWeek);
        }
    }

    public void refresh() {
        this.monthpanel.refresh();
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.monthpanel.getHeaderRenderer();
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        this.monthpanel.setHeaderRenderer(headerRenderer);
    }

    public Object getValue() {
        return this.dateSelectionModel.getSelectedDate();
    }

    public void setValue(Object value) {
        try {
            this.setDate(CalendarUtils.convertToDate(value));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public void setValues(Object[] values) {
        this.dateSelectionModel.setSelectedDates(values);
        this.refreshSelection();
    }

    public boolean[] getWorkingDays() {
        return this.workingDays;
    }

    public void setWorkingDays(boolean[] workingDays) {
        boolean[] old = this.monthpanel.getWorkingdays();
        this.monthpanel.setWorkingdays(workingDays);
        this.workingDays = workingDays;
        this.firePropertyChange("workingDays", old, workingDays);
    }

    public synchronized void addKeyListener(KeyListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = DatePanel.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener, listener);
    }

    public synchronized void removeKeyListener(KeyListener listener) {
        this.listenerList.remove(class$java$awt$event$KeyListener == null ? (class$java$awt$event$KeyListener = DatePanel.class$("java.awt.event.KeyListener")) : class$java$awt$event$KeyListener, listener);
    }

    private void fireKeyListenerKeyTyped(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$KeyListener == null ? DatePanel.class$("java.awt.event.KeyListener") : class$java$awt$event$KeyListener)) continue;
            ((KeyListener)listeners[i + 1]).keyTyped(event);
        }
    }

    private void fireKeyListenerKeyPressed(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$KeyListener == null ? DatePanel.class$("java.awt.event.KeyListener") : class$java$awt$event$KeyListener)) continue;
            ((KeyListener)listeners[i + 1]).keyPressed(event);
        }
    }

    private void fireKeyListenerKeyReleased(KeyEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$KeyListener == null ? DatePanel.class$("java.awt.event.KeyListener") : class$java$awt$event$KeyListener)) continue;
            ((KeyListener)listeners[i + 1]).keyReleased(event);
        }
    }

    public void setEnabled(boolean enabled) {
        this.monthpanel.setEnabled(enabled);
        this.monthscroller.setEnabled(enabled);
        this.yearscroller.setEnabled(enabled);
        super.setEnabled(enabled);
        this.repaint();
    }

    public boolean isEnabled() {
        return this.monthpanel.isEnabled();
    }

    public Object[] getValues() {
        return this.dateSelectionModel.getSelectedDates();
    }

    public void setSelectionMode(int mode) {
        int old = this.dateSelectionModel.getSelectionMode();
        this.dateSelectionModel.setSelectionMode(mode);
        this.refreshSelection();
        this.firePropertyChange("selectionMode", old, mode);
    }

    public int getSelectionMode() {
        return this.dateSelectionModel.getSelectionMode();
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionListenerActionPerformed(ActionEvent event) {
        ArrayList list;
        DatePanel datePanel = this;
        synchronized (datePanel) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (ArrayList)this.actionListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    public synchronized void addMonthChangeListener(MonthChangeListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$net$sf$nachocalendar$event$MonthChangeListener == null ? (class$net$sf$nachocalendar$event$MonthChangeListener = DatePanel.class$("net.sf.nachocalendar.event.MonthChangeListener")) : class$net$sf$nachocalendar$event$MonthChangeListener, listener);
    }

    public synchronized void removeMonthChangeListener(MonthChangeListener listener) {
        this.listenerList.remove(class$net$sf$nachocalendar$event$MonthChangeListener == null ? (class$net$sf$nachocalendar$event$MonthChangeListener = DatePanel.class$("net.sf.nachocalendar.event.MonthChangeListener")) : class$net$sf$nachocalendar$event$MonthChangeListener, listener);
    }

    private void fireMonthChangeListenerMonthIncreased(MonthChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$net$sf$nachocalendar$event$MonthChangeListener == null ? DatePanel.class$("net.sf.nachocalendar.event.MonthChangeListener") : class$net$sf$nachocalendar$event$MonthChangeListener)) continue;
            ((MonthChangeListener)listeners[i + 1]).monthIncreased(event);
        }
    }

    private void fireMonthChangeListenerMonthDecreased(MonthChangeEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$net$sf$nachocalendar$event$MonthChangeListener == null ? DatePanel.class$("net.sf.nachocalendar.event.MonthChangeListener") : class$net$sf$nachocalendar$event$MonthChangeListener)) continue;
            ((MonthChangeListener)listeners[i + 1]).monthDecreased(event);
        }
    }

    private void refreshSelection() {
        DayPanel[] daypanels = this.monthpanel.getDaypanels();
        for (int i = 0; i < daypanels.length; ++i) {
            if (!daypanels[i].isEnabled()) {
                daypanels[i].setSelected(false);
                continue;
            }
            daypanels[i].setSelected(this.dateSelectionModel.isSelectedDate(daypanels[i].getDate()));
        }
    }

    public DateSelectionModel getDateSelectionModel() {
        return this.dateSelectionModel;
    }

    public void setDateSelectionModel(DateSelectionModel dateSelectionModel) {
        if (dateSelectionModel != null) {
            this.dateSelectionModel = dateSelectionModel;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

