/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.RegistryKey;
import java.io.PrintWriter;

public abstract class RegistryValue {
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    protected static char[] hexChars;
    int type;
    String name;
    RegistryKey key;

    public RegistryValue(RegistryKey key, String name, int type) {
        this.key = key;
        this.name = name;
        this.type = type;
    }

    public RegistryKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void export(PrintWriter out) {
        out.print(String.valueOf(String.valueOf(new StringBuffer("\"").append(this.getName()).append("\"="))));
        out.println("\"ERROR called RegistryValue.export()!\"");
    }

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer("[type=").append(this.type).append(",name=").append(this.name).append("]")));
    }

    public static void exportHexData(PrintWriter out, byte[] data) {
        int len = data.length;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            byte dByte = data[i];
            char ch2 = hexChars[dByte & 0xF];
            char ch1 = hexChars[dByte >> 4 & 0xF];
            if (cnt == 0) {
                out.print("  ");
            }
            out.print(ch1);
            out.print(ch2);
            if (i < len - 1) {
                out.print(",");
            }
            if (++cnt <= 15) continue;
            cnt = 0;
            if (i >= len - 1) continue;
            out.println("\\");
        }
        out.println("");
    }

    public abstract byte[] getByteData();

    public abstract int getByteLength();

    public abstract void setByteData(byte[] var1);

    static {
        REG_NONE = 0;
        REG_SZ = 1;
        REG_EXPAND_SZ = 2;
        REG_BINARY = 3;
        REG_DWORD = 4;
        REG_DWORD_LITTLE_ENDIAN = 4;
        REG_DWORD_BIG_ENDIAN = 5;
        REG_LINK = 6;
        REG_MULTI_SZ = 7;
        REG_RESOURCE_LIST = 8;
        REG_FULL_RESOURCE_DESCRIPTOR = 9;
        REG_RESOURCE_REQUIREMENTS_LIST = 10;
        hexChars = new char[20];
        RegistryValue.hexChars[0] = 48;
        RegistryValue.hexChars[1] = 49;
        RegistryValue.hexChars[2] = 50;
        RegistryValue.hexChars[3] = 51;
        RegistryValue.hexChars[4] = 52;
        RegistryValue.hexChars[5] = 53;
        RegistryValue.hexChars[6] = 54;
        RegistryValue.hexChars[7] = 55;
        RegistryValue.hexChars[8] = 56;
        RegistryValue.hexChars[9] = 57;
        RegistryValue.hexChars[10] = 97;
        RegistryValue.hexChars[11] = 98;
        RegistryValue.hexChars[12] = 99;
        RegistryValue.hexChars[13] = 100;
        RegistryValue.hexChars[14] = 101;
        RegistryValue.hexChars[15] = 102;
    }
}

