/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.Dimension;
import edu.iris.Fissures.IfPlottable.PlottableDCOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.RequestFilterUtil;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleSeismogramClient;
import edu.sc.seis.fissuresUtil.simple.TestingClient;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePlottableClient
implements TestingClient {
    protected PlottableDCOperations plottableDC;
    private static final Logger logger = LoggerFactory.getLogger(SimplePlottableClient.class);

    public SimplePlottableClient() {
        String serverDNS = "edu/sc/seis";
        String serverName = "DelilahCache";
        try {
            Initializer.getNS().getPlottableDCObject(serverDNS, serverName);
            logger.info("Got PlottableDC as corba object. the name service is ok");
            this.plottableDC = BulletproofVestFactory.vestPlottableDC(serverDNS, serverName, Initializer.getNS());
            logger.info("got PlottableDC " + (this.plottableDC != null));
        }
        catch (InvalidName e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
        catch (NotFound e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
        catch (CannotProceed e) {
            logger.error("Problem with name service: ", (Throwable)e);
        }
    }

    @Override
    public void exercise() {
        this.retrieve_plottables(true);
    }

    public void retrieve_plottables() {
        this.retrieve_plottables(false);
    }

    public Plottable[] retrieve_plottables(boolean verbose) {
        try {
            RequestFilter rf = this.createLast24HoursRF();
            Dimension[] widths = this.plottableDC.get_whole_day_sizes();
            if (verbose) {
                logger.info("plottableDC has the following whole-day sizes:");
                for (int i = 0; i < widths.length; ++i) {
                    logger.info("" + widths[i].width);
                }
                logger.info("requesting plottable at " + widths[0].width + " pixels wide " + RequestFilterUtil.toString((RequestFilter)rf));
            }
            Plottable[] plots = this.plottableDC.get_plottable(rf, widths[0]);
            if (verbose) {
                this.printPlotResults(plots);
            }
            return plots;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printPlotResults(Plottable[] plots) {
        logger.info("got " + plots.length + " plottables from plottableDC");
        for (int i = 0; i < plots.length; ++i) {
            logger.info("plottable " + i + " has " + plots[i].x_coor.length + " pixels " + "and spans between pixels " + plots[i].x_coor[0] + " and " + plots[i].x_coor[plots[i].x_coor.length - 1]);
        }
    }

    public RequestFilter createLast24HoursRF() {
        MicroSecondDate now = new MicroSecondDate();
        MicroSecondDate yesterday = now.subtract(new TimeInterval(1.0, UnitImpl.DAY));
        return SimpleSeismogramClient.createRF(yesterday, now)[0];
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new SimplePlottableClient().exercise();
    }
}

