/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;

public class SacToFissures {
    public static LocalSeismogramImpl getSeismogram(File sacFile) throws FileNotFoundException, IOException, FissuresException {
        SacTimeSeries sac = new SacTimeSeries();
        sac.read(sacFile);
        return SacToFissures.getSeismogram(sac);
    }

    public static LocalSeismogramImpl getSeismogram(InputStream in) throws IOException, FissuresException {
        DataInputStream dis = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        SacTimeSeries sac = new SacTimeSeries();
        sac.read((DataInput)dis);
        return SacToFissures.getSeismogram(sac);
    }

    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac, SeismogramAttr attr) throws FissuresException {
        double error;
        LocalSeismogramImpl seis = new LocalSeismogramImpl(attr, sac.getY());
        if (seis.getNumPoints() != sac.getHeader().getNpts()) {
            seis.num_points = sac.getHeader().getNpts();
        }
        SamplingImpl samp = seis.getSampling();
        TimeInterval period = samp.getPeriod();
        if (sac.getHeader().getDelta() != 0.0f && (error = (period.convertTo(UnitImpl.SECOND).getValue() - (double)sac.getHeader().getDelta()) / (double)sac.getHeader().getDelta()) > 0.01) {
            seis.sampling_info = new SamplingImpl(1, new TimeInterval((double)sac.getHeader().getDelta(), UnitImpl.SECOND));
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getB())) {
            MicroSecondDate beginTime = SacToFissures.getSeismogramBeginTime(sac);
            double error2 = seis.getBeginTime().subtract(beginTime).divideBy((QuantityImpl)period).getValue();
            if (Math.abs(error2) > 0.01) {
                seis.begin_time = beginTime.getFissuresTime();
            }
        }
        return seis;
    }

    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac) throws FissuresException {
        TimeSeriesDataSel data = new TimeSeriesDataSel();
        data.flt_values(sac.getY());
        return new LocalSeismogramImpl((SeismogramAttr)SacToFissures.getSeismogramAttr(sac), data);
    }

    public static SeismogramAttrImpl getSeismogramAttr(SacTimeSeries sac) throws FissuresException {
        DecimalFormat df;
        MicroSecondDate beginTime = SacToFissures.getSeismogramBeginTime(sac);
        Time time = beginTime.getFissuresTime();
        ChannelId chanId = SacToFissures.getChannelId(sac);
        String evtName = "   ";
        SacHeader header = sac.getHeader();
        if (!SacConstants.isUndef((String)header.getKevnm())) {
            evtName = evtName + header.getKevnm().trim() + " ";
        }
        if (!(SacConstants.isUndef((float)header.getEvla()) || SacConstants.isUndef((float)header.getEvlo()) || SacConstants.isUndef((float)header.getEvdp()))) {
            evtName = evtName + "lat: " + header.getEvla() + " lon: " + header.getEvlo() + " depth: " + header.getEvdp() / 1000.0f + " km";
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getGcarc())) {
            df = new DecimalFormat("##0.#");
            evtName = evtName + "  " + df.format(header.getGcarc()) + " deg.";
        }
        if (!SacConstants.isUndef((float)sac.getHeader().getAz())) {
            df = new DecimalFormat("##0.#");
            evtName = evtName + "  az " + df.format(header.getAz()) + " deg.";
        }
        String seisId = chanId.network_id.network_code + ":" + chanId.station_code + ":" + chanId.site_code + ":" + chanId.channel_code + ":" + time.date_time;
        return new SeismogramAttrImpl(seisId, time, sac.getHeader().getNpts(), (Sampling)new SamplingImpl(1, new TimeInterval((double)sac.getHeader().getDelta(), UnitImpl.SECOND)), (Unit)UnitImpl.COUNT, chanId);
    }

    public static ChannelId getChannelId(SacTimeSeries sac) {
        return SacToFissures.getChannelId(sac.getHeader());
    }

    public static ChannelId getChannelId(SacHeader header) {
        if (!SacConstants.isUndef((String)header.getKhole()) && header.getKhole().trim().length() == 2) {
            return SacToFissures.getChannelId(header, header.getKhole().trim());
        }
        return SacToFissures.getChannelId(header, "  ");
    }

    public static ChannelId getChannelId(SacTimeSeries sac, String siteCode) {
        return SacToFissures.getChannelId(sac.getHeader(), siteCode);
    }

    public static ChannelId getChannelId(SacHeader header, String siteCode) {
        MicroSecondDate nzTime = SacToFissures.getNZTime(header);
        Time fisTime = nzTime.getFissuresTime();
        String netCode = "XX";
        if (!SacConstants.isUndef((String)header.getKnetwk())) {
            netCode = header.getKnetwk().trim().toUpperCase();
        }
        String staCode = "XXXXX";
        if (!SacConstants.isUndef((String)header.getKstnm())) {
            staCode = header.getKstnm().trim().toUpperCase();
        }
        String chanCode = "XXX";
        if (!SacConstants.isUndef((String)header.getKcmpnm()) && (chanCode = header.getKcmpnm().trim().toUpperCase()).length() == 5) {
            siteCode = Channel.fixLocCode((String)chanCode.substring(0, 2));
            chanCode = chanCode.substring(2, 5);
        }
        NetworkId netId = new NetworkId(netCode, fisTime);
        ChannelId id = new ChannelId(netId, staCode, siteCode, chanCode, fisTime);
        return id;
    }

    public static ChannelImpl getChannel(SacTimeSeries sac) {
        return SacToFissures.getChannel(sac.getHeader());
    }

    public static ChannelImpl getChannel(SacHeader header) {
        float stdp;
        ChannelId chanId = SacToFissures.getChannelId(header);
        float stel = header.getStel();
        if (stel == -12345.0f) {
            stel = 0.0f;
        }
        if ((stdp = header.getStdp()) == -12345.0f) {
            stdp = 0.0f;
        }
        Location loc = new Location(header.getStla(), header.getStlo(), (Quantity)new QuantityImpl((double)header.getStel(), (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)header.getStdp(), (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC);
        Orientation orient = new Orientation(header.getCmpaz(), header.getCmpinc() - 90.0f);
        SamplingImpl samp = new SamplingImpl(1, new TimeInterval((double)header.getDelta(), UnitImpl.SECOND));
        TimeRange effective = new TimeRange(chanId.network_id.begin_time, new Time("edu.iris.Fissures/Time/UNKNOWN"));
        NetworkAttrImpl netAttr = new NetworkAttrImpl(chanId.network_id, chanId.network_id.network_code, "", "", effective);
        StationId staId = new StationId(chanId.network_id, chanId.station_code, chanId.network_id.begin_time);
        StationImpl station = new StationImpl(staId, chanId.station_code, loc, effective, "", "", "from sac", (NetworkAttr)netAttr);
        SiteId siteId = new SiteId(chanId.network_id, chanId.station_code, chanId.site_code, chanId.network_id.begin_time);
        SiteImpl site = new SiteImpl(siteId, loc, effective, (Station)station, "from sac");
        return new ChannelImpl(chanId, chanId.channel_code, orient, (Sampling)samp, effective, (Site)site);
    }

    public static MicroSecondDate getNZTime(SacTimeSeries sac) {
        return SacToFissures.getNZTime(sac.getHeader());
    }

    public static MicroSecondDate getNZTime(SacHeader header) {
        if (SacConstants.isUndef((int)header.getNzyear()) || SacConstants.isUndef((int)header.getNzjday()) || SacConstants.isUndef((int)header.getNzhour()) || SacConstants.isUndef((int)header.getNzmin()) || SacConstants.isUndef((int)header.getNzsec()) || SacConstants.isUndef((int)header.getNzmsec())) {
            return ClockUtil.wayPast();
        }
        ISOTime isoTime = new ISOTime(header.getNzyear(), header.getNzjday(), header.getNzhour(), header.getNzmin(), (float)header.getNzsec() + (float)header.getNzmsec() / 1000.0f);
        MicroSecondDate originTime = isoTime.getDate();
        return originTime;
    }

    public static MicroSecondDate getEventOriginTime(SacTimeSeries sac) {
        return SacToFissures.getEventOriginTime(sac.getHeader());
    }

    public static MicroSecondDate getEventOriginTime(SacHeader header) {
        MicroSecondDate originTime = SacToFissures.getNZTime(header);
        TimeInterval sacOMarker = new TimeInterval((double)header.getO(), UnitImpl.SECOND);
        originTime = originTime.add(sacOMarker);
        return originTime;
    }

    public static MicroSecondDate getSeismogramBeginTime(SacTimeSeries sac) {
        return SacToFissures.getSeismogramBeginTime(sac.getHeader());
    }

    public static MicroSecondDate getSeismogramBeginTime(SacHeader header) {
        MicroSecondDate bTime = SacToFissures.getNZTime(header);
        TimeInterval sacBMarker = new TimeInterval((double)header.getB(), UnitImpl.SECOND);
        bTime = bTime.add(sacBMarker);
        return bTime;
    }

    public static CacheEvent getEvent(SacTimeSeries sac) {
        return SacToFissures.getEvent(sac.getHeader());
    }

    public static CacheEvent getEvent(SacHeader header) {
        if (!(SacConstants.isUndef((float)header.getO()) || SacConstants.isUndef((float)header.getEvla()) || SacConstants.isUndef((float)header.getEvlo()) || SacConstants.isUndef((float)header.getEvdp()))) {
            MicroSecondDate beginTime = SacToFissures.getEventOriginTime(header);
            EventAttrImpl attr = new EventAttrImpl("SAC Event");
            OriginImpl[] origins = new OriginImpl[1];
            Location loc = header.getEvdp() > 1000.0f ? new Location(header.getEvla(), header.getEvlo(), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)header.getEvdp(), (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC) : new Location(header.getEvla(), header.getEvlo(), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)header.getEvdp(), (Unit)UnitImpl.KILOMETER), LocationType.GEOGRAPHIC);
            origins[0] = new OriginImpl("genid:" + Math.round(Math.random() * 2.147483647E9), "", "", beginTime.getFissuresTime(), loc, new Magnitude[0], new ParameterRef[0]);
            return new CacheEvent((EventAttr)attr, (Origin[])origins, origins[0]);
        }
        return null;
    }
}

