/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.PoleZeroFilter;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.TransferType;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.seisFile.sac.Complex;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacPoleZero;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class FissuresToSac {
    private static Complex ONE = new Complex(1.0, 0.0);

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis) throws CodecException {
        float[] floatSamps;
        try {
            if (seis.can_convert_to_long()) {
                int[] idata = seis.get_as_longs();
                floatSamps = new float[idata.length];
                for (int i = 0; i < idata.length; ++i) {
                    floatSamps[i] = idata[i];
                }
            } else {
                floatSamps = seis.get_as_floats();
            }
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                throw (CodecException)e.getCause();
            }
            throw new CodecException(e.the_error.error_description);
        }
        SacHeader header = SacHeader.createEmptyEvenSampledTimeSeriesHeader();
        header.setIztype(9);
        SamplingImpl samp = (SamplingImpl)seis.sampling_info;
        TimeInterval period = samp.getPeriod();
        period = period.convertTo(UnitImpl.SECOND);
        float f = (float)period.get_value();
        header.setDelta(f);
        UnitImpl yUnit = (UnitImpl)seis.y_unit;
        QuantityImpl min = seis.getMinValue();
        header.setDepmin((float)min.convertTo((UnitImpl)yUnit).value);
        QuantityImpl max = seis.getMaxValue();
        header.setDepmax((float)max.convertTo((UnitImpl)yUnit).value);
        QuantityImpl mean = seis.getMeanValue();
        header.setDepmen((float)mean.convertTo((UnitImpl)yUnit).value);
        FissuresToSac.setKZTime(header, new MicroSecondDate(seis.begin_time));
        header.setKnetwk(seis.channel_id.network_id.network_code);
        header.setKstnm(seis.channel_id.station_code);
        header.setKcmpnm(seis.channel_id.channel_code);
        header.setKhole(seis.channel_id.site_code);
        return new SacTimeSeries(header, floatSamps);
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addChannel(sac.getHeader(), channel);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Origin origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        FissuresToSac.addOrigin(sac.getHeader(), origin);
        return sac;
    }

    public static SacTimeSeries getSAC(LocalSeismogramImpl seis, Channel channel, Origin origin) throws CodecException {
        SacTimeSeries sac = FissuresToSac.getSAC(seis);
        if (channel != null) {
            FissuresToSac.addChannel(sac.getHeader(), channel);
        }
        if (origin != null) {
            FissuresToSac.addOrigin(sac.getHeader(), origin);
        }
        if (origin != null && channel != null) {
            DistAz distAz = new DistAz(channel, origin);
            sac.getHeader().setGcarc((float)distAz.getDelta());
            sac.getHeader().setDist((float)distAz.getDelta() * 111.19f);
            sac.getHeader().setAz((float)distAz.getAz());
            sac.getHeader().setBaz((float)distAz.getBaz());
        }
        return sac;
    }

    public static void addChannel(SacHeader header, Channel channel) {
        header.setStla(channel.getSite().getLocation().latitude);
        header.setStlo(channel.getSite().getLocation().longitude);
        QuantityImpl z = (QuantityImpl)channel.getSite().getLocation().elevation;
        header.setStel((float)z.convertTo((UnitImpl)UnitImpl.METER).value);
        z = (QuantityImpl)channel.getSite().getLocation().depth;
        header.setStdp((float)z.convertTo((UnitImpl)UnitImpl.METER).value);
        header.setCmpaz(channel.getOrientation().azimuth);
        header.setCmpinc(90.0f + channel.getOrientation().dip);
    }

    public static void addOrigin(SacHeader header, Origin origin) {
        header.setEvla(origin.getLocation().latitude);
        header.setEvlo(origin.getLocation().longitude);
        QuantityImpl z = (QuantityImpl)origin.getLocation().elevation;
        header.setEvel((float)z.convertTo((UnitImpl)UnitImpl.METER).value);
        z = (QuantityImpl)origin.getLocation().depth;
        header.setEvdp((float)z.convertTo((UnitImpl)UnitImpl.METER).value);
        ISOTime isoTime = new ISOTime(header.getNzyear(), header.getNzjday(), header.getNzhour(), header.getNzmin(), (float)header.getNzsec() + (float)header.getNzmsec() / 1000.0f);
        MicroSecondDate beginTime = isoTime.getDate();
        MicroSecondDate originTime = new MicroSecondDate(origin.getOriginTime());
        FissuresToSac.setKZTime(header, originTime);
        TimeInterval sacBMarker = beginTime.subtract(originTime);
        sacBMarker = (TimeInterval)sacBMarker.convertTo(UnitImpl.SECOND);
        header.setB((float)sacBMarker.value);
        header.setO(0.0f);
        header.setIztype(11);
        if (origin.getMagnitudes().length > 0) {
            header.setMag(origin.getMagnitudes()[0].value);
        }
    }

    public static void setKZTime(SacHeader header, MicroSecondDate date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime((Date)date);
        header.setNzyear(cal.get(1));
        header.setNzjday(cal.get(6));
        header.setNzhour(cal.get(11));
        header.setNzmin(cal.get(12));
        header.setNzsec(cal.get(13));
        header.setNzmsec(cal.get(14));
    }

    public static SacPoleZero getPoleZero(Response response) throws InvalidResponse {
        InstrumentationLoader.repairResponse(response);
        InstrumentationLoader.checkResponse(response);
        Stage stage = response.stages[0];
        Filter filter = stage.filters[0];
        if (filter.discriminator().value() != 1) {
            throw new IllegalArgumentException("Unexpected response type " + filter.discriminator().value());
        }
        PoleZeroFilter pz = filter.pole_zero_filter();
        int gamma = 0;
        UnitImpl unit = (UnitImpl)stage.input_units;
        QuantityImpl scaleUnit = new QuantityImpl(1.0, (Unit)unit);
        if (unit.isConvertableTo(UnitImpl.METER)) {
            gamma = 0;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER);
        } else if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND)) {
            gamma = 1;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER_PER_SECOND);
        } else if (unit.isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            gamma = 2;
            scaleUnit = scaleUnit.convertTo(UnitImpl.METER_PER_SECOND_PER_SECOND);
        } else {
            throw new IllegalArgumentException("response unit is not displacement, velocity or acceleration: " + unit);
        }
        int num_zeros = pz.zeros.length + gamma;
        double mulFactor = 1.0;
        if (stage.type == TransferType.ANALOG) {
            mulFactor = Math.PI * 2;
        }
        Complex[] zeros = SacPoleZero.initCmplx((int)num_zeros);
        for (int i = 0; i < pz.zeros.length; ++i) {
            zeros[i] = new Complex((double)pz.zeros[i].real * mulFactor, (double)pz.zeros[i].imaginary * mulFactor);
        }
        Complex[] poles = SacPoleZero.initCmplx((int)pz.poles.length);
        for (int i = 0; i < pz.poles.length; ++i) {
            poles[i] = new Complex((double)pz.poles[i].real * mulFactor, (double)pz.poles[i].imaginary * mulFactor);
        }
        float constant = stage.the_normalization[0].ao_normalization_factor;
        double sd = response.the_sensitivity.sensitivity_factor;
        double fs = response.the_sensitivity.frequency;
        sd *= Math.pow(Math.PI * 2 * fs, gamma);
        double A0 = stage.the_normalization[0].ao_normalization_factor;
        double fn = stage.the_normalization[0].normalization_freq;
        A0 /= Math.pow(Math.PI * 2 * fn, gamma);
        if (stage.type == TransferType.ANALOG) {
            A0 *= Math.pow(Math.PI * 2, pz.poles.length - pz.zeros.length);
        }
        constant = poles.length == 0 && zeros.length == 0 ? (float)(sd * A0) : (float)(sd * FissuresToSac.calc_A0(poles, zeros, fs));
        constant = (float)((double)constant * scaleUnit.getValue());
        return new SacPoleZero(poles, zeros, constant);
    }

    private static double calc_A0(Complex[] poles, Complex[] zeros, double ref_freq) {
        int i;
        Complex numer = ONE;
        Complex denom = ONE;
        Complex f0 = new Complex(0.0, Math.PI * 2 * ref_freq);
        for (i = 0; i < zeros.length; ++i) {
            denom = Complex.mul((Complex)denom, (Complex)Complex.sub((Complex)f0, (Complex)zeros[i]));
        }
        for (i = 0; i < poles.length; ++i) {
            numer = Complex.mul((Complex)numer, (Complex)Complex.sub((Complex)f0, (Complex)poles[i]));
        }
        double a0 = Complex.div((Complex)numer, (Complex)denom).mag();
        return a0;
    }
}

