/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockChannelId;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockSite;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockStation;

public class MockChannel {
    private static final Orientation VERTICAL = new Orientation(0.0f, -90.0f);
    private static final Orientation EAST = new Orientation(90.0f, 0.0f);
    private static final Orientation NORTH = new Orientation(0.0f, 0.0f);
    private static final Orientation[] ORIENTATIONS = new Orientation[]{VERTICAL, NORTH, EAST};

    public static ChannelImpl createChannel() {
        return MockChannel.createChannel(MockChannelId.createVerticalChanId(), "Vertical Channel", MockSite.createSite(), VERTICAL);
    }

    public static ChannelImpl createNorthChannel() {
        return MockChannel.createChannel(MockChannelId.createNorthChanId(), "North Channel", MockSite.createSite(), NORTH);
    }

    public static ChannelImpl createEastChannel() {
        return MockChannel.createChannel(MockChannelId.createEastChanId(), "East Channel", MockSite.createSite(), EAST);
    }

    public static ChannelImpl createOtherSiteSameStationChan() {
        return MockChannel.createChannel(MockChannelId.createOtherSiteSameStationChanId(), "Other Site Same Station Vertical Channel", MockSite.createOtherSiteSameStation(), VERTICAL);
    }

    public static ChannelImpl createOtherNetChan() {
        return MockChannel.createChannel(MockChannelId.createOtherNetChanId(), "Other Net Vertical Channel", MockSite.createOtherSite(), VERTICAL);
    }

    public static ChannelImpl[] createChannelsAtLocs(Location[] locs) {
        ChannelImpl[] chans = new ChannelImpl[locs.length];
        for (int i = 0; i < chans.length; ++i) {
            chans[i] = MockChannel.createChannel(locs[i]);
        }
        return chans;
    }

    public static ChannelImpl createChannel(Location location) {
        return MockChannel.createChannel(MockSite.createSite(location));
    }

    public static ChannelImpl createChannel(Site site) {
        return MockChannel.createChannel(MockChannelId.createChanId("BHZ", site), "fake chan", site, VERTICAL);
    }

    public static ChannelImpl createChannel(Station station) {
        return MockChannel.createChannel(station, "00", "BHZ");
    }

    public static ChannelImpl createChannel(Station station, String siteCode, String chanCode) {
        Site s = MockSite.createSite(station, siteCode);
        Orientation o = VERTICAL;
        if (chanCode.endsWith("N")) {
            o = NORTH;
        } else if (chanCode.endsWith("E")) {
            o = EAST;
        }
        return MockChannel.createChannel(MockChannelId.createChanId(chanCode, s), "fake chan", s, o);
    }

    public static ChannelImpl createChannelWithId(ChannelId chanId) {
        Orientation o = chanId.channel_code.endsWith("Z") ? VERTICAL : (chanId.channel_code.endsWith("N") ? NORTH : (chanId.channel_code.endsWith("E") ? EAST : VERTICAL));
        return MockChannel.createChannel(chanId, "", MockSite.createSite((Station)MockStation.createStation(), chanId.site_code), o);
    }

    private static ChannelImpl createChannel(ChannelId id, String info, Site s, Orientation o) {
        return new ChannelImpl(id, info, o, (Sampling)new SamplingImpl(20, new TimeInterval(1.0, UnitImpl.SECOND)), s.getEffectiveTime(), s);
    }

    public static ChannelImpl[] createMotionVector() {
        return MockChannel.createMotionVector((Station)MockStation.createStation());
    }

    public static ChannelImpl[] createMotionVector(Station station) {
        ChannelImpl[] channels = new ChannelImpl[3];
        Site s = MockSite.createSite(station);
        String[] codes = new String[]{"BHZ", "BHN", "BHE"};
        for (int i = 0; i < codes.length; ++i) {
            channels[i] = MockChannel.createChannel(MockChannelId.createChanId(codes[i], s), "Motion Vector Channel " + codes[i], s, ORIENTATIONS[i]);
        }
        return channels;
    }

    public static ChannelGroup createGroup() {
        return new ChannelGroup(MockChannel.createMotionVector());
    }
}

