/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.Location;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.exceptionHandler.DefaultExtractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.HibernateUtil;
import edu.sc.seis.fissuresUtil.hibernate.PrintIfNotCalledOff;
import edu.sc.seis.fissuresUtil.hibernate.SessionStackTrace;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.StatelessSession;
import org.hibernate.classic.Session;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateDB {
    public static boolean DEBUG_SESSION_CREATION = true;
    public static int DEBUG_SESSION_CREATION_SECONDS = 300;
    private static ThreadLocal<HashSet<UnitImpl>> unitCacheTL = new ThreadLocal<HashSet<UnitImpl>>(){

        @Override
        protected synchronized HashSet<UnitImpl> initialValue() {
            return new HashSet<UnitImpl>();
        }
    };
    private static boolean commonUnitsSaved = false;
    private static ThreadLocal<org.hibernate.Session> sessionTL = new ThreadLocal();
    private static List<WeakReference<SessionStackTrace>> knownSessions = Collections.synchronizedList(new LinkedList());
    private static TimeInterval MAX_SESSION_LIFE = new TimeInterval(300.0, UnitImpl.SECOND);
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateDB.class);

    public AbstractHibernateDB() {
        logger.debug("init " + this);
    }

    public static Object getTXID() {
        if (ConnMgr.getDB_TYPE().equals("POSTGRES")) {
            SQLQuery query = AbstractHibernateDB.getSession().createSQLQuery("select virtualtransaction from pg_locks where pid = pg_backend_pid()");
            return query.list().get(0);
        }
        return "";
    }

    private static synchronized void saveCommonUnits() {
        Session s = HibernateUtil.getSessionFactory().openSession();
        s.beginTransaction();
        Query q = s.createQuery("From edu.iris.Fissures.model.UnitImpl");
        List result = q.list();
        if (result.size() == 0) {
            AbstractHibernateDB.saveCommonUnit((org.hibernate.Session)s, UnitImpl.METER);
            AbstractHibernateDB.saveCommonUnit((org.hibernate.Session)s, UnitImpl.KILOMETER);
            AbstractHibernateDB.saveCommonUnit((org.hibernate.Session)s, UnitImpl.SECOND);
            AbstractHibernateDB.saveCommonUnit((org.hibernate.Session)s, UnitImpl.METER_PER_SECOND);
        }
        s.getTransaction().commit();
        s.close();
        commonUnitsSaved = true;
    }

    private static synchronized void saveCommonUnit(org.hibernate.Session s, UnitImpl unitToAdd) {
        if (!unitToAdd.isBaseUnit()) {
            for (UnitImpl subU : unitToAdd.getSubUnitsList()) {
                AbstractHibernateDB.saveCommonUnit(s, subU);
            }
        }
        s.saveOrUpdate((Object)unitToAdd);
        logger.debug("save " + unitToAdd + " to database");
    }

    private static void loadUnits(org.hibernate.Session s) {
        Query q = s.createQuery("From edu.iris.Fissures.model.UnitImpl");
        List result = q.list();
        AbstractHibernateDB.getUnitCache().addAll(result);
    }

    public static void deploySchema() throws Exception {
        AbstractHibernateDB.deploySchema(false);
    }

    public static void deploySchema(boolean failOnException) throws Exception {
        SchemaUpdate update = new SchemaUpdate(HibernateUtil.getConfiguration());
        update.setHaltOnError(true);
        update.execute(false, true);
        List exceptions = update.getExceptions();
        for (Throwable t : exceptions) {
            logger.error("problem in deploySchema: ", t);
        }
        if (failOnException && exceptions.size() > 0) {
            Throwable first = (Throwable)exceptions.get(0);
            if (first instanceof Exception) {
                throw (Exception)first;
            }
            throw (RuntimeException)first;
        }
    }

    protected static org.hibernate.Session createSession() {
        if (!commonUnitsSaved) {
            AbstractHibernateDB.saveCommonUnits();
        }
        Session cacheSession = HibernateUtil.getSessionFactory().openSession();
        cacheSession.beginTransaction();
        if (DEBUG_SESSION_CREATION) {
            knownSessions.add(new WeakReference<SessionStackTrace>(new SessionStackTrace((org.hibernate.Session)cacheSession, Thread.currentThread().getStackTrace())));
        }
        return cacheSession;
    }

    public static StatelessSession getReadOnlySession() {
        return HibernateUtil.getSessionFactory().openStatelessSession();
    }

    public static boolean isSessionOpen() {
        return sessionTL.get() != null;
    }

    public static org.hibernate.Session getSession() {
        org.hibernate.Session s = sessionTL.get();
        if (s == null) {
            s = AbstractHibernateDB.createSession();
            sessionTL.set(s);
        }
        return s;
    }

    public static void flush() {
        org.hibernate.Session s = sessionTL.get();
        if (s == null) {
            throw new RuntimeException("Can not flush before session creation");
        }
        s.flush();
    }

    public static void commit() {
        org.hibernate.Session s = sessionTL.get();
        if (s == null) {
            logger.info("Commit session before creation, nothing to do");
            return;
        }
        PrintIfNotCalledOff delayMessage = new PrintIfNotCalledOff("TRANSACTION Commit on " + s + "  " + AbstractHibernateDB.getTXID());
        sessionTL.set(null);
        unitCacheTL.set(null);
        s.getTransaction().commit();
        s.close();
        delayMessage.callOff();
    }

    public static void rollback() {
        org.hibernate.Session s = sessionTL.get();
        if (s == null) {
            return;
        }
        sessionTL.set(null);
        unitCacheTL.set(null);
        try {
            s.getTransaction().rollback();
        }
        catch (HibernateException hibernateException) {
        }
        finally {
            s.close();
        }
    }

    public static void internUnit(Location loc) {
        AbstractHibernateDB.internUnit(loc.depth);
        AbstractHibernateDB.internUnit(loc.elevation);
    }

    public static void internUnit(Quantity q) {
        q.the_units = AbstractHibernateDB.intern((UnitImpl)q.the_units);
    }

    protected static UnitImpl intern(UnitImpl unit) {
        if (unit == null || unit.getDbid() != null && unit.getDbid() != 0) {
            return unit;
        }
        HashSet<UnitImpl> unitCache = AbstractHibernateDB.getUnitCache();
        if (unitCache.size() == 0) {
            AbstractHibernateDB.loadUnits(AbstractHibernateDB.getSession());
        }
        for (UnitImpl internUnit : unitCache) {
            if (!unit.equals((Object)internUnit)) continue;
            return internUnit;
        }
        if (unit.getBaseUnit().equals(UnitBase.COMPOSITE)) {
            UnitImpl[] internedSubUnits = new UnitImpl[unit.getNumSubUnits()];
            for (int i = 0; i < unit.getNumSubUnits(); ++i) {
                internedSubUnits[i] = AbstractHibernateDB.intern(unit.getSubUnit(i));
            }
            unit = new UnitImpl((Unit[])internedSubUnits, unit.getPower(), unit.name, unit.getMultiFactor(), unit.getExponent());
        }
        AbstractHibernateDB.getSession().save((Object)unit);
        unitCache.add(unit);
        return unit;
    }

    protected static HashSet<UnitImpl> getUnitCache() {
        HashSet<Object> out = unitCacheTL.get();
        if (out == null) {
            out = new HashSet();
            unitCacheTL.set(out);
        }
        return out;
    }

    static {
        GlobalExceptionHandler.add(new DefaultExtractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof SQLException;
            }

            @Override
            public String extract(Throwable throwable) {
                return super.extract(throwable);
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                if (throwable instanceof SQLException) {
                    return ((SQLException)throwable).getNextException();
                }
                return null;
            }
        });
        if (DEBUG_SESSION_CREATION) {
            logger.info("zombie session checker started");
            Timer t = new Timer("zombie session checker", true);
            t.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = knownSessions;
                    synchronized (list) {
                        Iterator iterator = knownSessions.iterator();
                        while (iterator.hasNext()) {
                            SessionStackTrace item = (SessionStackTrace)((WeakReference)iterator.next()).get();
                            if (item == null || !item.session.isOpen()) {
                                iterator.remove();
                                continue;
                            }
                            if (!ClockUtil.now().subtract(MAX_SESSION_LIFE).after((Date)item.createTime)) continue;
                            TimeInterval aliveTime = (TimeInterval)ClockUtil.now().subtract(item.createTime).convertTo(UnitImpl.SECOND);
                            logger.debug("Session still open after " + aliveTime + " seconds. create time=" + item.createTime);
                            for (int i = 0; i < item.stackTrace.length; ++i) {
                                logger.debug(item.stackTrace[i].toString());
                            }
                        }
                    }
                }
            }, DEBUG_SESSION_CREATION_SECONDS * 1000, (long)(DEBUG_SESSION_CREATION_SECONDS * 1000));
        }
    }
}

