/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.gmt;

import edu.sc.seis.fissuresUtil.gmt.ConvertExecute;
import edu.sc.seis.fissuresUtil.gmt.GenericCommandExecute;
import edu.sc.seis.fissuresUtil.gmt.MapProjectExecute;
import edu.sc.seis.fissuresUtil.gmt.PSXYExecute;
import java.io.IOException;

public class MapCropper {
    private int width;
    private int height;
    private int leftOffset;
    private int bottomOffset;
    private int top;
    private int right;
    private int bottom;
    private int left;

    public MapCropper(int width, int height, int leftOffset, int bottomOffset, int top, int right, int bottom, int left) {
        this.width = width;
        this.height = height;
        this.leftOffset = leftOffset;
        this.bottomOffset = bottomOffset;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.left = left;
    }

    public int[][] translatePoints(int[][] rawPoints) {
        int[][] translatedPoints = new int[rawPoints.length][2];
        for (int i = 0; i < rawPoints.length; ++i) {
            int x = rawPoints[i][0];
            int y = rawPoints[i][1];
            x = x + this.leftOffset - this.left;
            y = this.height - y - this.bottomOffset - this.top;
            translatedPoints[i][0] = x;
            translatedPoints[i][1] = y;
        }
        return translatedPoints;
    }

    public void crop(String filename) throws InterruptedException, IOException {
        String command = "mogrify -crop " + this.getNewWidth() + "x" + this.getNewHeight() + "+" + this.left + "+" + this.top + " " + filename;
        GenericCommandExecute.execute(command);
    }

    public static void main(String[] args) {
        try {
            int i;
            String projection = "Kf166/10i";
            String region = "-14/346/-90/90";
            double[][] stationCoords = new double[][]{{-180.0, 90.0}, {-135.0, 67.5}, {-90.0, 45.0}, {-45.0, 22.5}, {0.0, 0.0}};
            double[][] eventCoords = new double[][]{{45.0, -22.5}, {90.0, -45.0}, {135.0, -67.5}, {180.0, -90.0}};
            PSXYExecute.addPoints("world.ps", projection, region, "t0.4", "0/0/255", "5/255", (double[][])stationCoords);
            PSXYExecute.addPoints("world.ps", projection, region, "c0.7", null, "12/255/0/0", (double[][])eventCoords);
            int[][] rawStationPoints = MapProjectExecute.forward(projection, region, stationCoords);
            int[][] rawEventPoints = MapProjectExecute.forward(projection, region, eventCoords);
            ConvertExecute.convert("world.ps", "world.png", "-antialias -rotate 90");
            MapCropper cropper = new MapCropper(842, 595, 72, 72, 150, 22, 45, 60);
            cropper.crop("world.png");
            int[][] stationPoints = cropper.translatePoints(rawStationPoints);
            int[][] eventPoints = cropper.translatePoints(rawEventPoints);
            System.out.println("calculated station points: ");
            for (i = 0; i < stationPoints.length; ++i) {
                System.out.println(stationPoints[i][0] + " " + stationPoints[i][1]);
            }
            System.out.println("calculated event points: ");
            for (i = 0; i < eventPoints.length; ++i) {
                System.out.println(eventPoints[i][0] + " " + eventPoints[i][1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getBottomOffset() {
        return this.bottomOffset;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLeft() {
        return this.left;
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getNewWidth() {
        return this.width - this.right - this.left;
    }

    public int getNewHeight() {
        return this.height - this.top - this.bottom;
    }
}

