/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.flow.tester.model;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.flow.extractor.model.QuantityExtractor;
import edu.sc.seis.fissuresUtil.flow.tester.Fail;
import edu.sc.seis.fissuresUtil.flow.tester.NoTestSubject;
import edu.sc.seis.fissuresUtil.flow.tester.Pass;
import edu.sc.seis.fissuresUtil.flow.tester.TestResult;
import edu.sc.seis.fissuresUtil.flow.tester.Tester;

public abstract class QuantityRangeTester
implements Tester {
    private QuantityImpl min;
    private QuantityImpl max;
    private UnitImpl unit;
    private QuantityExtractor extractor;

    public QuantityRangeTester(QuantityImpl min, QuantityImpl max) {
        this.min = min;
        this.max = max.convertTo(min.getUnit());
        this.unit = min.getUnit();
    }

    public QuantityImpl getMin() {
        return this.min;
    }

    public QuantityImpl getMax() {
        return this.max;
    }

    public void setExtractor(QuantityExtractor qe) {
        this.extractor = qe;
    }

    @Override
    public TestResult test(Object o) {
        QuantityImpl q = this.extractor.extract(o);
        if (q == null) {
            return new NoTestSubject("Unable to extract from " + o);
        }
        if ((q = q.convertTo(this.unit)).getValue() < this.min.getValue()) {
            return new Fail(q + " is too small");
        }
        if (q.getValue() > this.max.getValue()) {
            return new Fail(q + " is too large");
        }
        return new Pass(q + " is within range");
    }
}

