/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.mouse;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.awt.Component;
import java.awt.event.MouseEvent;

public class SDMouseEvent
extends MouseEvent {
    private SeismogramDisplay sd;

    public SDMouseEvent(SeismogramDisplay sd, MouseEvent me) {
        super((Component)me.getSource(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
        this.sd = sd;
    }

    public MicroSecondDate getTime(int pixel) {
        MicroSecondTimeRange tr = this.getDisplay().getTimeConfig().getTime();
        return SimplePlotUtil.getValue(this.getComponent().getWidth(), tr.getBeginTime(), tr.getEndTime(), pixel);
    }

    public int getPixel(MicroSecondDate time) {
        MicroSecondTimeRange tr = this.getDisplay().getTimeConfig().getTime();
        return SimplePlotUtil.getPixel(this.getComponent().getWidth(), tr.getBeginTime(), tr.getEndTime(), time);
    }

    public MicroSecondDate getTime() {
        MicroSecondTimeRange currRange = this.getDisplay().getTimeConfig().getTime();
        long beginMicros = currRange.getBeginTime().getMicroSecondTime();
        double intervalMicros = currRange.getInterval().getValue();
        double xPer = this.getXPercent();
        return new MicroSecondDate((long)((double)beginMicros + intervalMicros * xPer));
    }

    public QuantityImpl getAmp() {
        UnitRangeImpl cur = this.getDisplay().getAmpConfig().getAmp();
        Component comp = this.getComponent();
        double yPercent = (double)(comp.getHeight() - this.getY()) / (double)comp.getHeight();
        double amp = (cur.getMaxValue() - cur.getMinValue()) * yPercent + cur.getMinValue();
        return new QuantityImpl(amp, (Unit)cur.getUnit());
    }

    public static SDMouseEvent wrap(MouseEvent e) {
        return new SDMouseEvent(((SeismogramDisplayProvider)e.getComponent()).provide(), e);
    }

    public double getXPercent() {
        return (double)this.getX() / (double)this.getComponent().getWidth();
    }

    public SeismogramDisplay getDisplay() {
        return this.sd;
    }
}

