/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public abstract class BigX
extends MouseAdapter
implements Drawable,
MouseMotionListener {
    private Color drawColor = Color.BLACK;
    private int xMax = 10;
    private int xMin = 5;
    private int yMax = 10;
    private int yMin = 5;
    private boolean visible = true;
    private boolean inside = true;

    public BigX(SeismogramDisplayProvider display) {
        display.addMouseListener(this);
        display.addMouseMotionListener(this);
    }

    public abstract void clicked();

    public void setXY(int x, int y) {
        this.xMin = x;
        this.xMax = x + 5;
        this.yMin = y;
        this.yMax = y + 5;
    }

    @Override
    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        if (this.visible && !SeismogramDisplay.PRINTING) {
            canvas.setColor(this.drawColor);
            canvas.setStroke(DisplayUtils.THREE_PIXEL_STROKE);
            canvas.drawLine(this.xMin, this.yMin, this.xMax, this.yMax);
            canvas.drawLine(this.xMin, this.yMax, this.xMax, this.yMin);
            canvas.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
        }
    }

    @Override
    public Color getColor() {
        return this.drawColor;
    }

    @Override
    public void setColor(Color c) {
        throw new UnsupportedOperationException("These colors are controlled by mousing, you can't set them");
    }

    @Override
    public void setVisibility(boolean b) {
        this.visible = b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.intersects(e)) {
            this.clicked();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColor(Color.RED);
        } else {
            this.setDrawColor(Color.BLACK);
        }
    }

    public void useInsets(boolean insideInsets) {
        this.inside = insideInsets;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColor(Color.RED);
        } else {
            this.setDrawColor(Color.BLACK);
        }
    }

    protected boolean intersects(MouseEvent e) {
        int clickX = e.getX();
        int clickY = e.getY();
        return clickX >= this.xMin && clickX <= this.xMax && clickY >= this.yMin && clickY <= this.yMax;
    }

    private void setDrawColor(Color newColor) {
        this.drawColor = newColor;
    }

    public Color getDrawColor() {
        return this.drawColor;
    }
}

