/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ScaleMapper;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;

public class ScaleBorder
extends AbstractBorder {
    private Rectangle2D leftAxisLabelBounds;
    private static FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
    protected int top = 0;
    protected int left = 0;
    protected int bottom = 0;
    protected int right = 0;
    protected int majorTickLength = 8;
    protected int minorTickLength = 4;
    private static int fontHeight;
    protected ScaleMapper topScaleMap;
    protected ScaleMapper leftScaleMap;
    protected ScaleMapper bottomScaleMap;
    protected ScaleMapper rightScaleMap;

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets i) {
        i.top = this.top;
        i.left = this.left;
        i.right = this.right;
        i.bottom = this.bottom;
        return new Insets(this.top, this.left, this.bottom, this.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            copy.translate(x, y);
            try {
                String label;
                int pixelLoc;
                int i;
                int numTicks;
                copy.setFont(DisplayUtils.BORDER_FONT);
                copy.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                Insets insets = ((JComponent)c).getInsets();
                insets = new Insets(insets.top - y, insets.left - x, insets.bottom, insets.right);
                FontMetrics fm = copy.getFontMetrics();
                ScaleMapper map = this.topScaleMap;
                if (map != null) {
                    numTicks = map.getNumTicks();
                    for (i = 0; i < numTicks; ++i) {
                        pixelLoc = map.getPixelLocation(i) + insets.left;
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.majorTickLength));
                            label = map.getLabel(i);
                            if (label == null || label.length() == 0) continue;
                            int labelWidth = (int)fm.getStringBounds(label, copy).getWidth();
                            copy.drawString(label, pixelLoc - labelWidth / 2, this.top - this.majorTickLength - 3);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.minorTickLength));
                    }
                    copy.drawString(map.getAxisLabel(), width / 2, fontHeight);
                }
                if ((map = this.leftScaleMap) != null) {
                    numTicks = map.getNumTicks();
                    if (numTicks == 0 || numTicks == 1) {
                        copy.drawString("No Data", fontHeight + 2, this.top + (height - this.top - this.bottom) / 2 - fm.getLeading());
                    } else {
                        for (i = 0; i < numTicks; ++i) {
                            pixelLoc = height - map.getPixelLocation(i) - this.bottom;
                            if (map.isMajorTick(i)) {
                                copy.draw(new Line2D.Float(this.left, pixelLoc, this.left - this.majorTickLength, pixelLoc));
                                label = map.getLabel(i);
                                if (label == null || label.length() == 0) continue;
                                Rectangle2D stringBounds = fm.getStringBounds(label, copy);
                                copy.drawString(label, (int)((double)(this.left - this.majorTickLength) - stringBounds.getWidth()) - 2, pixelLoc + fm.getAscent() / 2 - 2);
                                continue;
                            }
                            copy.draw(new Line2D.Float(this.left - this.minorTickLength, pixelLoc, this.left, pixelLoc));
                        }
                        if (this.leftAxisLabelBounds == null) {
                            this.leftAxisLabelBounds = copy.getFontMetrics().getStringBounds(map.getAxisLabel(), copy);
                        }
                        double yTranslate = (double)insets.top + ((double)(height - insets.top - insets.bottom) + this.leftAxisLabelBounds.getWidth()) / 2.0;
                        double xTranslate = this.leftAxisLabelBounds.getHeight();
                        copy.translate(xTranslate, yTranslate);
                        copy.rotate(-1.5707963267948966);
                        copy.drawString(map.getAxisLabel(), 0, 0);
                        copy.rotate(1.5707963267948966);
                        copy.translate(-xTranslate, -yTranslate);
                    }
                }
                if ((map = this.bottomScaleMap) != null) {
                    numTicks = map.getNumTicks();
                    for (i = 0; i < numTicks; ++i) {
                        pixelLoc = insets.left + map.getPixelLocation(i);
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.majorTickLength));
                            label = map.getLabel(i);
                            Rectangle2D labelBounds = fm.getStringBounds(label, copy);
                            int labelWidth = (int)labelBounds.getWidth();
                            int labelHeight = (int)labelBounds.getHeight();
                            if (label == null || label.length() == 0) continue;
                            copy.drawString(label, pixelLoc - labelWidth / 2, height - this.bottom + this.majorTickLength + labelHeight);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.minorTickLength));
                    }
                    String label2 = map.getAxisLabel();
                    Rectangle2D labelBounds = fm.getStringBounds(label2, copy);
                    copy.drawString(label2, (int)((double)insets.left + ((double)(width - insets.left - insets.right) - labelBounds.getWidth()) / 2.0), height - 5);
                }
                if ((map = this.rightScaleMap) != null) {
                    numTicks = map.getNumTicks();
                    for (i = 0; i < numTicks; ++i) {
                        pixelLoc = height - map.getPixelLocation(i) - this.bottom;
                        copy.draw(new Line2D.Float(pixelLoc, c.getSize().height - this.bottom, pixelLoc, c.getSize().height - this.bottom / 2));
                        label = map.getLabel(i);
                        if (label == null || label.length() == 0) continue;
                        copy.drawString(label, pixelLoc, c.getSize().height - fm.getLeading());
                    }
                }
            }
            finally {
                copy.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int paintLeftAmpBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int saveLeft = this.left;
        this.left = width;
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            copy.translate(x, y);
            copy.setClip(0, 0, width, height);
            try {
                copy.setFont(DisplayUtils.BORDER_FONT);
                copy.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
                Insets insets = ((JComponent)c).getInsets();
                insets = new Insets(insets.top - y, insets.left - x, insets.bottom, insets.right);
                FontMetrics fm = copy.getFontMetrics();
                ScaleMapper map = this.leftScaleMap;
                if (map != null) {
                    int numTicks = map.getNumTicks();
                    if (numTicks == 0 || numTicks == 1) {
                        copy.drawString("No Data", fontHeight + 2, this.top + (height - this.top) / 2 - fm.getLeading());
                    } else {
                        for (int i = 0; i < numTicks; ++i) {
                            int pixelLoc = map.getPixelLocation(i) + 3;
                            pixelLoc = this.remapPixels(pixelLoc, 0, height, map.getTotalPixels(), 0);
                            if (map.isMajorTick(i)) {
                                copy.draw(new Line2D.Float(this.left, pixelLoc, this.left - this.majorTickLength, pixelLoc));
                                String label = map.getLabel(i);
                                if (label == null || label.length() == 0) continue;
                                Rectangle2D stringBounds = fm.getStringBounds(label, copy);
                                copy.drawString(label, (int)((double)(this.left - this.majorTickLength) - stringBounds.getWidth()) - 2, pixelLoc + fm.getAscent() / 2 - 2);
                                continue;
                            }
                            copy.draw(new Line2D.Float(this.left - this.minorTickLength, pixelLoc, this.left, pixelLoc));
                        }
                        if (this.leftAxisLabelBounds == null) {
                            this.leftAxisLabelBounds = copy.getFontMetrics().getStringBounds(map.getAxisLabel(), copy);
                        }
                        double yTranslate = (double)insets.top + ((double)(height - insets.top) + this.leftAxisLabelBounds.getWidth()) / 2.0;
                        double xTranslate = this.leftAxisLabelBounds.getHeight();
                        copy.translate(xTranslate, yTranslate);
                        copy.rotate(-1.5707963267948966);
                        copy.drawString(map.getAxisLabel(), 0, 0);
                        copy.rotate(1.5707963267948966);
                        copy.translate(-xTranslate, -yTranslate);
                    }
                }
            }
            finally {
                copy.dispose();
            }
        }
        this.left = saveLeft;
        return width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintAmpBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            copy.translate(x, y);
            try {
                String label;
                int pixelLoc;
                int i;
                int numTicks;
                copy.setFont(DisplayUtils.BORDER_FONT);
                copy.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                Insets insets = ((JComponent)c).getInsets();
                insets = new Insets(insets.top - y, insets.left - x, insets.bottom, insets.right);
                FontMetrics fm = copy.getFontMetrics();
                ScaleMapper map = this.topScaleMap;
                if (map != null) {
                    numTicks = map.getNumTicks();
                    for (i = 0; i < numTicks; ++i) {
                        pixelLoc = map.getPixelLocation(i) + insets.left;
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.majorTickLength));
                            label = map.getLabel(i);
                            if (label == null || label.length() == 0) continue;
                            int labelWidth = (int)fm.getStringBounds(label, copy).getWidth();
                            copy.drawString(label, pixelLoc - labelWidth / 2, this.top - this.majorTickLength - 3);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.minorTickLength));
                    }
                    copy.drawString(map.getAxisLabel(), width / 2, fontHeight);
                }
                if ((map = this.bottomScaleMap) != null) {
                    numTicks = map.getNumTicks();
                    for (i = 0; i < numTicks; ++i) {
                        pixelLoc = insets.left + map.getPixelLocation(i);
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.majorTickLength));
                            label = map.getLabel(i);
                            Rectangle2D labelBounds = fm.getStringBounds(label, copy);
                            int labelWidth = (int)labelBounds.getWidth();
                            int labelHeight = (int)labelBounds.getHeight();
                            if (label == null || label.length() == 0) continue;
                            copy.drawString(label, pixelLoc - labelWidth / 2, height - this.bottom + this.majorTickLength + labelHeight);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.minorTickLength));
                    }
                    String label2 = map.getAxisLabel();
                    Rectangle2D labelBounds = fm.getStringBounds(label2, copy);
                    copy.drawString(label2, (int)((double)insets.left + ((double)(width - insets.left - insets.right) - labelBounds.getWidth()) / 2.0), height - 5);
                }
            }
            finally {
                copy.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int paintTopTimeBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int saveTop = this.top;
        this.top = height;
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            copy.translate(x, y);
            try {
                copy.setFont(DisplayUtils.BORDER_FONT);
                copy.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
                Insets insets = ((JComponent)c).getInsets();
                insets = new Insets(y, x, 0, 0);
                FontMetrics fm = copy.getFontMetrics();
                ScaleMapper map = this.topScaleMap;
                if (map != null) {
                    int numTicks = map.getNumTicks();
                    for (int i = 0; i < numTicks; ++i) {
                        int pixelLoc = map.getPixelLocation(i) + insets.left;
                        pixelLoc = this.remapPixels(pixelLoc, 0, 0, map.getTotalPixels(), width);
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.majorTickLength));
                            String label = map.getLabel(i);
                            if (label == null || label.length() == 0) continue;
                            int labelWidth = (int)fm.getStringBounds(label, copy).getWidth();
                            copy.drawString(label, pixelLoc - labelWidth / 2, this.top - this.majorTickLength - 3);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, this.top, pixelLoc, this.top - this.minorTickLength));
                    }
                    copy.drawString(map.getAxisLabel(), width / 2 - SwingUtilities.computeStringWidth(fm, map.getAxisLabel()) / 2, this.top - this.majorTickLength - fontHeight - 3);
                }
            }
            finally {
                copy.dispose();
            }
        }
        this.top = saveTop;
        return height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int paintBottomTimeBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int saveTop = this.top;
        int saveBottom = this.bottom;
        this.top = height;
        Graphics2D copy = (Graphics2D)g.create();
        if (copy != null) {
            copy.translate(x, y);
            try {
                copy.setFont(DisplayUtils.BORDER_FONT);
                copy.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
                Insets insets = ((JComponent)c).getInsets();
                insets = new Insets(insets.top - y, insets.left - x, insets.bottom, insets.right);
                FontMetrics fm = copy.getFontMetrics();
                ScaleMapper map = this.bottomScaleMap;
                if (map != null) {
                    int numTicks = map.getNumTicks();
                    for (int i = 0; i < numTicks; ++i) {
                        int pixelLoc = insets.left + map.getPixelLocation(i);
                        pixelLoc = this.remapPixels(pixelLoc, 0, 0, map.getTotalPixels(), width);
                        if (map.isMajorTick(i)) {
                            copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.majorTickLength));
                            String label = map.getLabel(i);
                            Rectangle2D labelBounds = fm.getStringBounds(label, copy);
                            int labelWidth = (int)labelBounds.getWidth();
                            int labelHeight = (int)labelBounds.getHeight();
                            if (label == null || label.length() == 0) continue;
                            copy.drawString(label, pixelLoc - labelWidth / 2, height - this.bottom + this.majorTickLength + labelHeight);
                            continue;
                        }
                        copy.draw(new Line2D.Float(pixelLoc, height - this.bottom, pixelLoc, height - this.bottom + this.minorTickLength));
                    }
                    String label = map.getAxisLabel();
                    Rectangle2D labelBounds = fm.getStringBounds(label, copy);
                    copy.drawString(label, (int)((double)insets.left + ((double)(width - insets.left - insets.right) - labelBounds.getWidth()) / 2.0), height - 5);
                }
            }
            finally {
                copy.dispose();
            }
        }
        this.top = saveTop;
        this.bottom = saveBottom;
        return width;
    }

    public int getLabelWidth() {
        return this.left;
    }

    public int getLabelHeight() {
        return this.top;
    }

    public void setTopScaleMapper(ScaleMapper scaleMap) {
        this.topScaleMap = scaleMap;
        this.top = scaleMap.getAxisLabel() != null && !scaleMap.getAxisLabel().equals("") ? this.majorTickLength + 2 * ScaleBorder.getFontHeight(scaleMap.getAxisLabel()) + 5 : this.majorTickLength + ScaleBorder.getFontHeight("test") + 5;
    }

    public void clearTopScaleMapper() {
        this.topScaleMap = null;
        this.top = 0;
    }

    public ScaleMapper getTopScaleMapper() {
        return this.topScaleMap;
    }

    public void setLeftScaleMapper(ScaleMapper scaleMap) {
        this.leftScaleMap = scaleMap;
        this.left = scaleMap.getAxisLabel() != null ? ScaleBorder.getFontHeight(scaleMap.getAxisLabel()) + 60 : 60;
    }

    public void clearLeftScaleMapper() {
        this.leftScaleMap = null;
        this.left = 0;
    }

    public ScaleMapper getLeftScaleMapper() {
        return this.leftScaleMap;
    }

    public void setBottomScaleMapper(ScaleMapper scaleMap) {
        this.bottomScaleMap = scaleMap;
        this.bottom = scaleMap.getAxisLabel() != null && !scaleMap.getAxisLabel().equals("") ? this.majorTickLength + 2 * ScaleBorder.getFontHeight(scaleMap.getAxisLabel()) + 5 : 20;
    }

    public void clearBottomScaleMapper() {
        this.bottomScaleMap = null;
        this.bottom = 0;
    }

    public ScaleMapper getBottomScaleMapper() {
        return this.bottomScaleMap;
    }

    public void setRightScaleMapper(ScaleMapper scaleMap) {
        this.rightScaleMap = scaleMap;
        this.right = 50;
    }

    public void clearRightScaleMapper() {
        this.rightScaleMap = null;
        this.right = 0;
    }

    public ScaleMapper getRightScaleMapper() {
        return this.rightScaleMap;
    }

    public int getMajorTickLength() {
        return this.majorTickLength;
    }

    public void setMajorTickLength(int v) {
        this.majorTickLength = v;
    }

    public int getMinorTickLength() {
        return this.minorTickLength;
    }

    public void setMinorTickLength(int v) {
        this.minorTickLength = v;
    }

    public static int getFontHeight(String text) {
        if (fontHeight == 0) {
            LineMetrics lm = DisplayUtils.BORDER_FONT.getLineMetrics(text, frc);
            fontHeight = (int)lm.getHeight();
        }
        return fontHeight;
    }

    public int remapPixels(int xval, int xa, int ya, int xb, int yb) {
        return (int)Math.round(SimplePlotUtil.linearInterp(xa, ya, xb, yb, xval));
    }
}

