/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.FilteredDataSetSeismogram;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticleMotionView
extends JComponent {
    private Map timeConfigToFilterColor = new HashMap();
    private String displayKey;
    private Map keysToAmpConfigs = new HashMap();
    LinkedList parMos = new LinkedList();
    Map azimuths = new HashMap();
    List sectors = new LinkedList();
    UnitRangeImpl horizRange = DisplayUtils.ONE_RANGE;
    UnitRangeImpl vertRange = DisplayUtils.ONE_RANGE;
    private ParticleMotionDisplay pmd;
    private ParticleMotionStatusTable statusTable;
    private static int filterCount = SeismogramDisplay.COLORS.length / 2;
    private static Logger logger = LoggerFactory.getLogger(ParticleMotionView.class);
    private int i = 0;

    public ParticleMotionView(ParticleMotionDisplay particleMotionDisplay) {
        this.pmd = particleMotionDisplay;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ParticleMotionView.this.resize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ParticleMotionView.this.resize();
            }
        });
    }

    public synchronized void resize() {
        this.setSize(super.getSize());
        this.repaint();
    }

    public void add(NamedFilter filter) {
        for (ParticleMotion cur : this.parMos) {
            cur.add(filter, this.getColor(cur.getTimeConfig(), filter));
        }
        this.repaint();
    }

    public void remove(NamedFilter filter) {
        Iterator it = this.parMos.iterator();
        while (it.hasNext()) {
            ((ParticleMotion)it.next()).remove(filter);
        }
        this.repaint();
    }

    public void setOriginal(boolean visible) {
        Iterator it = this.parMos.iterator();
        while (it.hasNext()) {
            ((ParticleMotion)it.next()).setVisible(visible);
        }
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        ParticleMotion particleMotion;
        int counter;
        if (this.displayKey == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)g;
        for (counter = 0; counter < this.parMos.size(); ++counter) {
            particleMotion = (ParticleMotion)this.parMos.get(counter);
            if (!this.displayKey.equals(particleMotion.key) || !particleMotion.isHorizontalPlane()) continue;
            this.drawAzimuth(particleMotion, graphics2D);
            break;
        }
        for (counter = 0; counter < this.parMos.size(); ++counter) {
            particleMotion = (ParticleMotion)this.parMos.get(counter);
            if (!this.displayKey.equals(particleMotion.key)) continue;
            particleMotion.draw(g, this.getSize());
        }
    }

    public void drawAzimuth(ParticleMotion particleMotion, Graphics2D graphics2D) {
        if (!particleMotion.isHorizontalPlane()) {
            return;
        }
        Shape sector = this.getSectorShape();
        graphics2D.setPaint(Color.LIGHT_GRAY);
        graphics2D.fill(sector);
        graphics2D.draw(sector);
        this.drawAzimuths(graphics2D);
        graphics2D.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
    }

    public void drawTitles(LocalSeismogramImpl hseis, LocalSeismogramImpl vseis) {
        this.pmd.setHorizontalTitle(hseis.getName());
        this.pmd.setVerticalTitle(vseis.getName());
    }

    public void drawAzimuths(Graphics2D g2D) {
        Insets insets = this.getInsets();
        double fmin = super.getSize().getWidth() - (double)insets.left - (double)insets.right;
        double fmax = super.getSize().getHeight() - (double)insets.top - (double)insets.bottom;
        int originx = (int)(fmin / 2.0);
        int originy = (int)(fmax / 2.0);
        int newx = originx;
        int newy = originy;
        Iterator it = this.azimuths.keySet().iterator();
        g2D.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
        while (it.hasNext()) {
            Double key = (Double)it.next();
            Color parMoCo = (Color)this.azimuths.get(key);
            if (parMoCo == null) continue;
            g2D.setColor(new Color(parMoCo.getRed(), parMoCo.getGreen(), parMoCo.getBlue(), 96));
            GeneralPath generalPath = new GeneralPath();
            double degrees = key;
            int x = (int)(fmin * Math.cos(Math.toRadians(degrees)));
            int y = (int)(fmax * Math.sin(Math.toRadians(degrees)));
            generalPath.moveTo(newx + x, newy - y);
            generalPath.lineTo(newx - x, newy + y);
            g2D.draw(generalPath);
        }
    }

    public synchronized Shape getSectorShape() {
        Insets insets = this.getInsets();
        double fmin = super.getSize().getWidth() - (double)insets.left - (double)insets.right;
        double fmax = super.getSize().getHeight() - (double)insets.top - (double)insets.bottom;
        int originx = (int)(fmin / 2.0);
        int originy = (int)(fmax / 2.0);
        int newx = originx;
        int newy = originy;
        GeneralPath generalPath = new GeneralPath();
        int size = this.sectors.size();
        for (int counter = 0; counter < size; ++counter) {
            Point2D.Double point = (Point2D.Double)this.sectors.get(counter);
            double degreeone = point.getX();
            double degreetwo = point.getY();
            int xone = (int)(fmin * Math.cos(Math.toRadians(degreeone)));
            int yone = (int)(fmax * Math.sin(Math.toRadians(degreeone)));
            generalPath.moveTo(newx + xone, newy - yone);
            generalPath.lineTo(newx - xone, newy + yone);
            int xtwo = (int)(fmin * Math.cos(Math.toRadians(degreetwo)));
            int ytwo = (int)(fmax * Math.sin(Math.toRadians(degreetwo)));
            generalPath.lineTo(newx - xtwo, newy + ytwo);
            generalPath.lineTo(newx + xtwo, newy - ytwo);
            generalPath.lineTo(newx + xone, newy - yone);
        }
        return generalPath;
    }

    public synchronized void add(DataSetSeismogram hseis, DataSetSeismogram vseis, TimeConfig tc, Color color, String key, boolean horizPlane) {
        ParticleMotion newParMo = new ParticleMotion(hseis, vseis, tc, color, key, horizPlane);
        this.parMos.add(newParMo);
        for (NamedFilter cur : SeismogramDisplay.activeFilters) {
            color = this.getColor(tc, cur);
            newParMo.add(cur, color);
        }
        if (this.statusTable != null) {
            this.statusTable.add(newParMo);
        }
        this.pmd.resize();
    }

    private Color getColor(TimeConfig tc, NamedFilter filter) {
        HashMap<NamedFilter, Color> filterToColor = (HashMap<NamedFilter, Color>)this.timeConfigToFilterColor.get(tc);
        if (filterToColor == null) {
            filterToColor = new HashMap<NamedFilter, Color>();
            this.timeConfigToFilterColor.put(tc, filterToColor);
        }
        if (!filterToColor.containsKey(filter)) {
            filterToColor.put(filter, SeismogramDisplay.COLORS[filterCount++ % SeismogramDisplay.COLORS.length]);
        }
        return (Color)filterToColor.get(filter);
    }

    public void addSector(double degreeone, double degreetwo) {
        this.sectors.add(new Point2D.Double(degreeone, degreetwo));
    }

    public void addAzimuthLine(double degrees, Color color) {
        this.azimuths.put(new Double(degrees), color);
    }

    @Override
    public void setSize(Dimension d) {
        if (d.width < d.height) {
            super.setSize(new Dimension(d.width, d.width));
        } else {
            super.setSize(new Dimension(d.height, d.height));
        }
    }

    public void setDisplayKey(String key) {
        this.displayKey = key;
        this.pmd.setActiveAmpConfig(this.getAmpConfig(this.displayKey));
    }

    public JTable getStatusTable() {
        if (this.statusTable == null) {
            this.statusTable = new ParticleMotionStatusTable(this.parMos);
        }
        return this.statusTable;
    }

    private AmpConfig getAmpConfig(String key) {
        AmpConfig ac = (AmpConfig)this.keysToAmpConfigs.get(key);
        if (ac == null) {
            ac = new RMeanAmpConfig();
            this.keysToAmpConfigs.put(key, ac);
        }
        return ac;
    }

    private static JLabel generateLabel(ParticleMotion parMo) {
        JLabel label = new JLabel(parMo.toString(), 0);
        label.setForeground(parMo.getColor());
        return label;
    }

    private class ParticleMotionStatusTable
    extends JTable {
        private List cellStructs = new ArrayList();

        public ParticleMotionStatusTable(List parMos) {
            this.setModel(new ViewTableModel());
            this.setDefaultRenderer(String.class, new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return ((CellStruct)((ParticleMotionStatusTable)ParticleMotionStatusTable.this).cellStructs.get((int)row)).comp;
                }
            });
            this.setColumnWidths();
            Iterator it = parMos.iterator();
            while (it.hasNext()) {
                this.add((ParticleMotion)it.next());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComponent(ParticleMotion parMo, JComponent comp) {
            List list = this.cellStructs;
            synchronized (list) {
                TimeConfig tc = parMo.getTimeConfig();
                for (CellStruct cur : this.cellStructs) {
                    if (!cur.tc.equals(tc)) continue;
                    cur.comp = comp;
                    this.rowHeight = comp.getPreferredSize().height;
                    this.revalidate();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ParticleMotion parMo) {
            List list = this.cellStructs;
            synchronized (list) {
                TimeConfig tc = parMo.getTimeConfig();
                for (CellStruct cur : this.cellStructs) {
                    if (!cur.tc.equals(tc)) continue;
                    this.setOrientation(parMo.key, cur);
                    return;
                }
                CellStruct cell = new CellStruct(tc);
                this.cellStructs.add(cell);
                cell.name = parMo.toString();
                cell.comp = new JLabel(cell.name, 0);
                cell.comp.setForeground(parMo.getColor());
                this.setOrientation(parMo.key, cell);
            }
        }

        private void setOrientation(String key, CellStruct cell) {
            if (key.equals("North-East")) {
                cell.orientations[0] = Boolean.TRUE;
            } else if (key.equals("Up-North")) {
                cell.orientations[1] = Boolean.TRUE;
            } else {
                cell.orientations[2] = Boolean.TRUE;
            }
        }

        private void setColumnWidths() {
            int columnCount = this.getColumnCount();
            for (int counter = 0; counter < columnCount; ++counter) {
                String columnName = this.getColumnName(counter);
                int width = 50;
                width = columnName.equals("Trace") ? 100 : 20;
                this.getColumnModel().getColumn(counter).setPreferredWidth(width);
                this.getColumnModel().getColumn(counter).setMinWidth(width);
            }
        }

        private class CellStruct {
            public TimeConfig tc;
            public Boolean[] orientations = new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE};
            public JComponent comp;
            public String name;

            public CellStruct(TimeConfig tc) {
                this.tc = tc;
            }
        }

        private class ViewTableModel
        extends AbstractTableModel {
            private String[] keys = new String[]{"North-East", "Up-North", "Up-East"};

            private ViewTableModel() {
            }

            @Override
            public int getColumnCount() {
                return this.keys.length + 1;
            }

            @Override
            public int getRowCount() {
                return ParticleMotionStatusTable.this.cellStructs.size();
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex > 0) {
                    return this.keys[columnIndex - 1];
                }
                return "Trace";
            }

            public Class getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Boolean.class;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                List list = ParticleMotionStatusTable.this.cellStructs;
                synchronized (list) {
                    if (ParticleMotionStatusTable.this.cellStructs.size() > rowIndex) {
                        if (columnIndex == 0) {
                            return ((CellStruct)((ParticleMotionStatusTable)ParticleMotionStatusTable.this).cellStructs.get((int)rowIndex)).name;
                        }
                        return ((CellStruct)((ParticleMotionStatusTable)ParticleMotionStatusTable.this).cellStructs.get((int)rowIndex)).orientations[columnIndex - 1];
                    }
                }
                return null;
            }
        }
    }

    private class ParticleMotion
    implements TimeListener,
    AmpListener,
    SeismogramContainerListener {
        Map filterToParMo = new HashMap();
        private String name;
        private SeismogramContainer horiz;
        private SeismogramContainer vert;
        public String key = new String();
        private boolean visible = true;
        private MicroSecondTimeRange tr;
        private Color color;
        private boolean horizPlane = false;
        private AmpEvent ae;
        private TimeConfig tc;

        public ParticleMotion(DataSetSeismogram hSeis, DataSetSeismogram vSeis, TimeConfig tc, Color color, String key, boolean horizPlane) {
            this.name = hSeis instanceof FilteredDataSetSeismogram ? hSeis.getName() : hSeis.getRequestFilter().channel_id.station_code;
            this.color = color;
            hSeis = (DataSetSeismogram)hSeis.clone();
            hSeis.setName(hSeis.getName() + ParticleMotionView.this.i++);
            vSeis = (DataSetSeismogram)vSeis.clone();
            vSeis.setName(vSeis.getName() + ParticleMotionView.this.i++);
            this.horiz = SeismogramContainerFactory.create(this, hSeis);
            this.vert = SeismogramContainerFactory.create(this, vSeis);
            this.tc = tc;
            this.key = key;
            this.setUpConfigs();
            this.horizPlane = horizPlane;
            if (horizPlane) {
                ParticleMotionView.this.pmd.displayBackAzimuth(hSeis.getDataSet(), hSeis.getRequestFilter().channel_id, color);
            }
            tc.shaleTime(0.1, 1.0);
            tc.shaleTime(-0.1, 1.0);
        }

        private void setUpConfigs() {
            DataSetSeismogram[] seis = new DataSetSeismogram[]{this.horiz.getDataSetSeismogram(), this.vert.getDataSetSeismogram()};
            AmpConfig ac = ParticleMotionView.this.getAmpConfig(this.key);
            if (!this.tc.contains(seis[0])) {
                this.tc.add(seis);
            }
            this.tc.addListener(ac);
            this.tc.addListener(this);
            ac.add(seis);
            ac.addListener(this);
        }

        private void tearDownConfigs() {
            DataSetSeismogram[] seis = new DataSetSeismogram[]{this.horiz.getDataSetSeismogram(), this.vert.getDataSetSeismogram()};
            AmpConfig ac = (AmpConfig)ParticleMotionView.this.keysToAmpConfigs.get(this.key);
            this.tc.removeListener(this);
            if (ac != null) {
                ac.remove(seis);
                ac.removeListener(this);
            }
        }

        public void draw(Graphics g, Dimension size) {
            if (this.visible) {
                Graphics2D g2D = (Graphics2D)g;
                if (this.horiz.getIterator(this.tr).numPointsLeft() <= 0 || this.vert.getIterator(this.tr).numPointsLeft() <= 0) {
                    return;
                }
                g2D.setColor(this.color);
                g2D.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                GeneralPath generalPath = new GeneralPath(0);
                boolean prevPointBad = true;
                SeismogramIterator hIt = this.horiz.getIterator(this.tr);
                UnitImpl horizUnit = hIt.getUnit();
                UnitRangeImpl horizRange = this.ae.getAmp(this.horiz.getDataSetSeismogram()).convertTo(horizUnit);
                double hMin = horizRange.getMinValue();
                double hMax = horizRange.getMaxValue();
                SeismogramIterator vIt = this.vert.getIterator(this.tr);
                UnitImpl vertUnit = vIt.getUnit();
                UnitRangeImpl vertRange = this.ae.getAmp(this.vert.getDataSetSeismogram()).convertTo(vertUnit);
                double vMin = vertRange.getMinValue();
                double vMax = vertRange.getMaxValue();
                while (hIt.hasNext() && vIt.hasNext()) {
                    double hVal = this.getVal(hIt, hMin, hMax, size.height);
                    double vVal = this.getVal(vIt, vMin, vMax, size.height);
                    if (hVal == 2.147483647E9 || vVal == 2.147483647E9) {
                        prevPointBad = true;
                        continue;
                    }
                    vVal *= -1.0;
                    vVal += (double)size.height;
                    if (prevPointBad) {
                        generalPath.moveTo((int)hVal, (int)vVal);
                        prevPointBad = false;
                        continue;
                    }
                    generalPath.lineTo((int)hVal, (int)vVal);
                }
                g2D.draw(generalPath);
            }
            Iterator it = this.filterToParMo.keySet().iterator();
            while (it.hasNext()) {
                ((ParticleMotion)this.filterToParMo.get(it.next())).draw(g, size);
            }
        }

        private double getVal(SeismogramIterator it, double minAmp, double maxAmp, int size) {
            double itVal = ((QuantityImpl)it.next()).getValue();
            itVal = Double.isNaN(itVal) ? 2.147483647E9 : (double)Math.round(SimplePlotUtil.linearInterp(minAmp, 0.0, maxAmp, size, itVal));
            return itVal;
        }

        @Override
        public void updateData() {
            ParticleMotionView.this.repaint();
        }

        @Override
        public void updateAmp(AmpEvent event) {
            this.ae = event;
            ParticleMotionView.this.repaint();
        }

        @Override
        public void updateTime(TimeEvent timeEvent) {
            this.tr = timeEvent.getTime();
            ParticleMotionView.this.repaint();
        }

        public boolean isHorizontalPlane() {
            return this.horizPlane;
        }

        public void add(NamedFilter filter, Color color) {
            if (!this.filterToParMo.containsKey(filter)) {
                this.filterToParMo.put(filter, new ParticleMotion(FilteredDataSetSeismogram.getFiltered(this.horiz.getDataSetSeismogram(), filter), FilteredDataSetSeismogram.getFiltered(this.vert.getDataSetSeismogram(), filter), this.tc, color, this.key, this.horizPlane));
                if (ParticleMotionView.this.statusTable != null) {
                    ParticleMotionView.this.statusTable.setComponent(this, this.generateLabel());
                }
            }
        }

        private JComponent generateLabel() {
            JPanel labelPanel = new JPanel(new GridLayout(this.filterToParMo.keySet().size() + 1, 1));
            labelPanel.add(ParticleMotionView.generateLabel(this));
            Iterator it = this.filterToParMo.keySet().iterator();
            while (it.hasNext()) {
                labelPanel.add(ParticleMotionView.generateLabel((ParticleMotion)this.filterToParMo.get(it.next())));
            }
            return labelPanel;
        }

        public void remove(NamedFilter filter) {
            if (this.filterToParMo.containsKey(filter)) {
                ((ParticleMotion)this.filterToParMo.get(filter)).tearDownConfigs();
                this.filterToParMo.remove(filter);
                if (ParticleMotionView.this.statusTable != null) {
                    ParticleMotionView.this.statusTable.setComponent(this, this.generateLabel());
                }
            }
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            if (visible) {
                this.setUpConfigs();
            } else {
                this.tearDownConfigs();
            }
        }

        public Color getColor() {
            return this.color;
        }

        public TimeConfig getTimeConfig() {
            return this.tc;
        }

        public String toString() {
            return this.name;
        }
    }
}

