/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.display.AmpScaleMapper;
import edu.sc.seis.fissuresUtil.display.BottomTitleBorder;
import edu.sc.seis.fissuresUtil.display.LeftTitleBorder;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplayThread;
import edu.sc.seis.fissuresUtil.display.ParticleMotionView;
import edu.sc.seis.fissuresUtil.display.ScaleBorder;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticleMotionDisplay
extends JPanel {
    private boolean initialized = false;
    public static final Integer PARTICLE_MOTION_LAYER = new Integer(2);
    protected AmpScaleMapper hAmpScaleMap;
    protected AmpScaleMapper vAmpScaleMap;
    protected LeftTitleBorder vTitleBorder;
    protected BottomTitleBorder hTitleBorder;
    protected ParticleMotionView view;
    private JPanel particleDisplayPanel = new JPanel(new BorderLayout());
    private JPanel radioPanel = new JPanel(new GridLayout(1, 0));
    private AbstractButton initialButton;
    static Logger logger = LoggerFactory.getLogger(ParticleMotionDisplay.class);
    private static final String[] labelStrings = new String[]{"North-East", "Up-North", "Up-East"};

    public ParticleMotionDisplay(DataSetSeismogram datasetSeismogram, TimeConfig tc, Color color) {
        this.setLayout(new BorderLayout());
        this.view = new ParticleMotionView(this);
        this.view.setSize(new Dimension(300, 300));
        this.particleDisplayPanel.add(this.view);
        this.hAmpScaleMap = new UpdatingAmpScaleMapper(50, 4);
        this.vAmpScaleMap = new UpdatingAmpScaleMapper(50, 4);
        ScaleBorder scaleBorder = new ScaleBorder();
        scaleBorder.setBottomScaleMapper(this.hAmpScaleMap);
        scaleBorder.setLeftScaleMapper(this.vAmpScaleMap);
        this.hTitleBorder = new BottomTitleBorder("X - axis Title");
        this.vTitleBorder = new LeftTitleBorder("Y - axis Title");
        CompoundBorder titleBorder = BorderFactory.createCompoundBorder(this.hTitleBorder, this.vTitleBorder);
        Border bevelBorder = BorderFactory.createRaisedBevelBorder();
        CompoundBorder bevelTitleBorder = BorderFactory.createCompoundBorder(bevelBorder, titleBorder);
        Border lowBevelBorder = BorderFactory.createLoweredBevelBorder();
        CompoundBorder scaleBevelBorder = BorderFactory.createCompoundBorder(scaleBorder, lowBevelBorder);
        this.particleDisplayPanel.setBorder(BorderFactory.createCompoundBorder(bevelTitleBorder, scaleBevelBorder));
        this.add(this.particleDisplayPanel);
        this.radioPanel.setVisible(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ParticleMotionDisplay.this.resize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ParticleMotionDisplay.this.resize();
            }
        });
        ParticleMotionDisplayThread t = new ParticleMotionDisplayThread(datasetSeismogram, tc, this, color);
        t.execute();
        this.formRadioSetPanel();
        this.initialized = t.getCompletion();
        if (this.initialized) {
            this.setInitialButton();
        }
        this.add((Component)this.radioPanel, "South");
    }

    public void setActiveAmpConfig(AmpConfig ac) {
        this.hAmpScaleMap.setAmpConfig(ac);
        this.vAmpScaleMap.setAmpConfig(ac);
    }

    public ParticleMotionView getView() {
        return this.view;
    }

    public synchronized void resize() {
        if (this.getSize().width == 0 || this.getSize().height == 0) {
            return;
        }
        Dimension dim = this.view.getSize();
        Insets insets = this.view.getInsets();
        int width = this.particleDisplayPanel.getSize().width;
        int height = this.particleDisplayPanel.getSize().height;
        if ((width = width - this.particleDisplayPanel.getInsets().left - this.particleDisplayPanel.getInsets().right) < (height = height - this.particleDisplayPanel.getInsets().top - this.particleDisplayPanel.getInsets().bottom)) {
            this.particleDisplayPanel.setSize(new Dimension(this.particleDisplayPanel.getSize().width, width + this.particleDisplayPanel.getInsets().top + this.particleDisplayPanel.getInsets().bottom));
        } else {
            this.particleDisplayPanel.setSize(new Dimension(height + this.particleDisplayPanel.getInsets().left + this.particleDisplayPanel.getInsets().right, this.particleDisplayPanel.getSize().height));
        }
        this.view.resize();
        if (this.hAmpScaleMap != null) {
            this.hAmpScaleMap.setTotalPixels(dim.width - insets.left - insets.right);
            this.vAmpScaleMap.setTotalPixels(dim.height - insets.top - insets.bottom);
        }
        this.repaint();
    }

    public synchronized void addParticleMotionDisplay(DataSetSeismogram datasetSeismogram, TimeConfig tc, Color color) {
        ParticleMotionDisplayThread t = new ParticleMotionDisplayThread(datasetSeismogram, tc, this, color);
        t.execute();
    }

    public synchronized void displayBackAzimuth(DataSet dataset, ChannelId chanId, Color color) {
        EventAccessOperations cacheEvent = dataset.getEvent();
        Channel channel = dataset.getChannel(chanId);
        if (cacheEvent != null) {
            try {
                Origin origin = cacheEvent.get_preferred_origin();
                Station station = channel.getSite().getStation();
                double azimuth = SphericalCoords.azimuth((double)station.getLocation().latitude, (double)station.getLocation().longitude, (double)origin.getLocation().latitude, (double)origin.getLocation().longitude);
                double angle = 90.0 - azimuth;
                this.view.addAzimuthLine(angle, color);
                this.view.addSector(angle + 5.0, angle - 5.0);
            }
            catch (NoPreferredOrigin npoe) {
                logger.debug("no preferred origin");
            }
        }
    }

    private void formRadioSetPanel() {
        JRadioButton[] radioButtons = new JRadioButton[3];
        for (int i = 0; i < radioButtons.length; ++i) {
            radioButtons[i] = new JRadioButton(labelStrings[i]);
            radioButtons[i].setActionCommand(labelStrings[i]);
            radioButtons[i].addItemListener(new RadioButtonListener());
        }
        this.initialButton = radioButtons[0];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int counter = 0; counter < radioButtons.length; ++counter) {
            buttonGroup.add(radioButtons[counter]);
            this.radioPanel.add(radioButtons[counter]);
        }
        this.radioPanel.setVisible(true);
    }

    private void setInitialButton() {
        this.initialButton.setSelected(true);
    }

    public void setHorizontalTitle(String name) {
        this.hTitleBorder.setTitle(name);
    }

    public void setVerticalTitle(String name) {
        this.vTitleBorder.setTitle(name);
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void add(NamedFilter filter) {
        this.view.add(filter);
    }

    public void remove(NamedFilter filter) {
        this.view.remove(filter);
    }

    public void setOriginal(boolean visible) {
        this.view.setOriginal(visible);
    }

    private class RadioButtonListener
    implements ItemListener {
        private RadioButtonListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ae) {
            if (ae.getStateChange() == 1) {
                String orientation = ((AbstractButton)ae.getItem()).getText();
                ParticleMotionDisplay.this.view.setDisplayKey(orientation);
                if (orientation.equals(labelStrings[0])) {
                    ParticleMotionDisplay.this.setVerticalTitle("North-South");
                    ParticleMotionDisplay.this.setHorizontalTitle("East-West");
                } else if (orientation.equals(labelStrings[1])) {
                    ParticleMotionDisplay.this.setVerticalTitle("Up-Down");
                    ParticleMotionDisplay.this.setHorizontalTitle("North-South");
                } else {
                    ParticleMotionDisplay.this.setVerticalTitle("Up-Down");
                    ParticleMotionDisplay.this.setHorizontalTitle("East-West");
                }
                ParticleMotionDisplay.this.repaint();
            }
            ParticleMotionDisplay.this.repaint();
        }
    }

    private class UpdatingAmpScaleMapper
    extends AmpScaleMapper {
        public UpdatingAmpScaleMapper(int totalPixels, int hintPixels) {
            super(totalPixels, hintPixels);
        }

        @Override
        public void updateAmp(AmpEvent e) {
            this.setUnitRange(e.getAmp());
            ParticleMotionDisplay.this.repaint();
        }
    }
}

