/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramSorter;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Component;

public class MultiSeismogramWindowDisplay
extends VerticalSeismogramDisplay {
    private SeismogramSorter sorter;

    public MultiSeismogramWindowDisplay(SeismogramSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public void add(DataSetSeismogram[] dss) {
        BasicSeismogramDisplay disp = null;
        for (int i = 0; i < dss.length; ++i) {
            if (this.contains(dss[i])) continue;
            DataSetSeismogram[] seismos = new DataSetSeismogram[]{dss[i]};
            disp = new BasicSeismogramDisplay(this.tc);
            disp.setParentDisplay(this);
            disp.add(seismos);
            int j = this.sorter.sort(dss[i]);
            this.addBSD(disp, j);
            disp.addSoundPlay();
        }
        this.setBorders();
    }

    protected void addBSD(BasicSeismogramDisplay disp, int pos) {
        this.getCenter().add((Component)disp, pos);
    }

    @Override
    public void remove(DataSetSeismogram[] dss) {
        this.removeFromSorter(dss);
        super.remove(dss);
    }

    @Override
    public boolean removeDisplay(BasicSeismogramDisplay disp) {
        DataSetSeismogram[] dss = disp.getSeismograms();
        boolean removed = super.removeDisplay(disp);
        if (removed) {
            this.removeFromSorter(dss);
        }
        return removed;
    }

    private void removeFromSorter(DataSetSeismogram[] dss) {
        for (int i = 0; i < dss.length; ++i) {
            this.sorter.remove(dss[i]);
        }
    }

    @Override
    public void clear() {
        this.sorter.clear();
        super.clear();
    }
}

