/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.dataset;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.dataset.DataSetChangeEvent;
import edu.sc.seis.fissuresUtil.dataset.DataSetChangeListener;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelOrganizer
implements Organizer {
    protected EventListenerList listenerList = new EventListenerList();
    DataSet rootDataSet;
    private static final Logger logger = LoggerFactory.getLogger(TopLevelOrganizer.class);

    public TopLevelOrganizer() {
        this(new MemoryDataSet(" no id: TopLevelOrganizer", "My Data", "nobody", new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "created in memory.")}));
    }

    public TopLevelOrganizer(DataSet root) {
        this.rootDataSet = root;
    }

    public DataSet getRootDataSet() {
        return this.rootDataSet;
    }

    public DataSet getNoEarthquakeDataSet() {
        DataSet ds = this.getRootDataSet();
        DataSet noEQDS = ds.getDataSet("No Earthquake");
        if (noEQDS == null) {
            noEQDS = new MemoryDataSet("NO_EQ", "No Earthquake", System.getProperty("user.name"), new AuditInfo[0]);
            this.addDataSet(noEQDS);
        }
        return noEQDS;
    }

    @Override
    public void addSeismogram(DataSetSeismogram seis, AuditInfo[] audit) {
        DataSet noEQDS = this.getNoEarthquakeDataSet();
        seis.setDataSet(noEQDS);
        noEQDS.addDataSetSeismogram(seis, audit);
        this.fireDataSetChanged(noEQDS);
    }

    @Override
    public void addSeismogram(DataSetSeismogram seis, EventAccessOperations event, AuditInfo[] audit) {
        this.addSeismogram(seis, audit);
        DataSet ds = this.getNoEarthquakeDataSet();
        ds.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", event, audit);
    }

    public void addSeismogram(DataSetSeismogram seis, DataSet dataSet, AuditInfo[] audit) {
        dataSet.addDataSetSeismogram(seis, audit);
        this.fireDataSetChanged(dataSet);
    }

    @Override
    public void addChannel(Channel chan, AuditInfo[] audit) {
        DataSet noEQDS = this.getNoEarthquakeDataSet();
        String channelParamName = "edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)chan.get_id());
        if (chan != null && noEQDS.getParameter(channelParamName) == null) {
            noEQDS.addParameter(channelParamName, chan, audit);
        }
    }

    @Override
    public void addChannel(Channel chan, EventAccessOperations event, AuditInfo[] audit) {
        this.addChannel(chan, audit);
    }

    @Override
    public void addDataSet(DataSet dataset, AuditInfo[] audit) {
        DataSet ds = this.getRootDataSet();
        ds.addDataSet(dataset, audit);
        this.fireDataSetChanged(ds);
    }

    public void addDataSet(DataSet dataSet) {
        this.addDataSet(dataSet, new AuditInfo[0]);
    }

    @Override
    public void addDataSetChangeListener(DataSetChangeListener l) {
        this.listenerList.add(DataSetChangeListener.class, l);
    }

    @Override
    public void removeDataSetChangeListener(DataSetChangeListener l) {
        this.listenerList.remove(DataSetChangeListener.class, l);
    }

    protected void fireDataSetChanged(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetChanged(changeEvent);
        }
    }

    protected void fireDataSetAdded(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetAdded(changeEvent);
        }
    }

    protected void fireDataSetRemoved(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetRemoved(changeEvent);
        }
    }
}

