/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import java.util.HashMap;
import java.util.Properties;

public class PopulationProperties {
    static HashMap nets = new HashMap();
    static HashMap stations = new HashMap();
    static HashMap channels = new HashMap();
    public static final String NET = "network.";
    public static final String NETWORK_REMAP = "network.remap.";
    public static final String CHANNEL_REMAP = "network.channel.remap.";
    public static final String BEGIN = ".beginTime";
    public static final String END = ".endTime";
    public static final String NAME = ".name";
    public static final String DESCRIPTION = ".description";
    public static final String OWNER = ".owner";

    public static NetworkAttrImpl getNetworkAttr(Properties props) {
        return PopulationProperties.getNetworkAttr(props.getProperty("network.remap.XX"), props);
    }

    public static NetworkAttrImpl getNetworkAttr(String netString, Properties props) {
        NetworkAttrImpl netAttr;
        if (netString.equals("XX") || netString.trim().length() == 0) {
            netString = props.getProperty(NETWORK_REMAP);
        }
        if (nets.containsKey(netString = props.getProperty("network.remap.." + netString, netString))) {
            netAttr = (NetworkAttrImpl)nets.get(netString);
        } else {
            TimeRange netEffectiveTime = new TimeRange(new Time(props.getProperty(NET + netString + BEGIN, TimeUtils.timeUnknown.date_time)), new Time(props.getProperty(NET + netString + END, TimeUtils.timeUnknown.date_time)));
            NetworkId netid = new NetworkId(netString.substring(0, 2).toUpperCase(), netEffectiveTime.start_time);
            netAttr = new NetworkAttrImpl(netid, props.getProperty(NET + netid.network_code + NAME, netString), props.getProperty(NET + netid.network_code + DESCRIPTION, ""), props.getProperty(NET + netid.network_code + OWNER, ""), netEffectiveTime);
            nets.put(netString, netAttr);
        }
        return netAttr;
    }

    public static Channel fix(Channel chan, Properties props) {
        String channelString;
        String key;
        StationImpl station;
        String netString = NetworkIdUtil.toStringNoDates((NetworkId)chan.get_id().network_id);
        NetworkAttrImpl netAttr = PopulationProperties.getNetworkAttr(netString, props);
        String stationString = (netString = NetworkIdUtil.toStringNoDates((NetworkId)netAttr.get_id())) + "." + chan.getSite().getStation().get_code();
        if (stations.containsKey(stationString)) {
            station = (StationImpl)stations.get(stationString);
        } else {
            String staPrefix = NET + stationString;
            TimeRange staEffectiveTime = new TimeRange(new Time(props.getProperty(staPrefix + BEGIN, TimeUtils.timeUnknown.date_time)), new Time(props.getProperty(staPrefix + END, TimeUtils.timeUnknown.date_time)));
            StationId stationId = new StationId(netAttr.get_id(), chan.getSite().getStation().get_code(), staEffectiveTime.start_time);
            station = new StationImpl(stationId, chan.getSite().getStation().getName(), chan.getSite().getStation().getLocation(), chan.getSite().getStation().getOperator(), chan.getSite().getStation().getDescription(), chan.getSite().getStation().getComment(), (NetworkAttr)netAttr);
            stations.put(stationString, station);
        }
        chan.get_id().channel_code = props.getProperty(CHANNEL_REMAP + chan.get_code(), chan.get_code());
        chan.get_id().channel_code = props.getProperty(CHANNEL_REMAP + chan.get_code().toLowerCase(), chan.get_code());
        if (props.containsKey(CHANNEL_REMAP + chan.getSite().get_code() + chan.get_code())) {
            chan.get_id().site_code = "";
            chan.getSite().get_id().site_code = "";
            chan.get_id().channel_code = props.getProperty(CHANNEL_REMAP + chan.getSite().get_code() + chan.get_code(), chan.get_code());
        }
        if (props.containsKey(key = CHANNEL_REMAP + chan.getSite().get_code().toLowerCase() + chan.get_code().toLowerCase())) {
            chan.get_id().site_code = "";
            chan.getSite().get_id().site_code = "";
            chan.get_id().channel_code = props.getProperty(key);
        }
        if (channels.containsKey(channelString = stationString + "." + chan.get_id().site_code + "." + chan.get_code())) {
            return (ChannelImpl)channels.get(channelString);
        }
        SiteId siteId = new SiteId(netAttr.get_id(), station.get_code(), chan.getSite().get_code(), station.getEffectiveTime().start_time);
        SiteImpl site = new SiteImpl(siteId, chan.getSite().getLocation(), station.getEffectiveTime(), (Station)station, chan.getSite().getComment());
        ChannelId chanId = new ChannelId(netAttr.get_id(), station.get_code(), siteId.site_code, chan.get_code(), station.getEffectiveTime().start_time);
        if (chan.getOrientation().dip == -90.0f && chan.getOrientation().azimuth == -12345.0f) {
            chan.getOrientation().azimuth = 0.0f;
        }
        if (chan.getSite().getLocation().elevation.value == -12345.0) {
            chan.getSite().getLocation().elevation.value = 0.0;
        }
        if (chan.getSite().getLocation().depth.value == -12345.0) {
            chan.getSite().getLocation().depth.value = 0.0;
        }
        ChannelImpl out = new ChannelImpl(chanId, chan.getName(), chan.getOrientation(), chan.getSamplingInfo(), station.getEffectiveTime(), (Site)site);
        channels.put(channelString, out);
        return out;
    }
}

