/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.TimeRange;
import edu.sc.seis.fissuresUtil.chooser.StationAcceptor;

public class AvailableDataStationAcceptor
implements StationAcceptor {
    protected DataCenterOperations dc;
    protected TimeRange range;

    public AvailableDataStationAcceptor(DataCenterOperations dc, TimeRange range) {
        this.dc = dc;
        this.range = range;
    }

    @Override
    public boolean accept(Station station) {
        RequestFilter[] request = this.createFakeRequest(station.get_id());
        return this.dc.available_data(request).length != 0;
    }

    public RequestFilter[] createFakeRequest(StationId stationId) {
        RequestFilter[] request = new RequestFilter[]{new RequestFilter(new ChannelId(stationId.network_id, stationId.station_code, "00", "BHZ", this.range.start_time), this.range.start_time, this.range.end_time), new RequestFilter(new ChannelId(stationId.network_id, stationId.station_code, "00", "BHZ", this.range.start_time), this.range.start_time, this.range.end_time), new RequestFilter(new ChannelId(stationId.network_id, stationId.station_code, "", "LHZ", this.range.start_time), this.range.start_time, this.range.end_time), new RequestFilter(new ChannelId(stationId.network_id, stationId.station_code, "", "LHZ", this.range.start_time), this.range.start_time, this.range.end_time)};
        return request;
    }
}

