/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.AuditElement;
import edu.iris.Fissures.IfNetwork.Calibration;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelIdIterHolder;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.ConcreteNetwork;
import edu.iris.Fissures.IfNetwork.ConcreteNetworkAccess;
import edu.iris.Fissures.IfNetwork.ConcreteNetworkAccessOperations;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.SiteNotFound;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.StationNotFound;
import edu.iris.Fissures.IfNetwork.TimeCorrection;
import edu.iris.Fissures.IfNetwork.VirtualNetworkAccess;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.sc.seis.fissuresUtil.cache.CorbaServerWrapper;
import org.omg.CORBA.NO_IMPLEMENT;

public abstract class ProxyNetworkAccess
implements NetworkAccess,
ConcreteNetworkAccessOperations,
CorbaServerWrapper {
    private NetworkAccess net;

    public ProxyNetworkAccess(NetworkAccess net) {
        this.setNetworkAccess(net);
    }

    @Override
    public void reset() {
        if (this.getNetworkAccess() instanceof ProxyNetworkAccess) {
            ((ProxyNetworkAccess)this.getNetworkAccess()).reset();
        } else if (this.getNetworkAccess() instanceof ConcreteNetworkAccess) {
            ((ConcreteNetworkAccess)this.net)._release();
            this.setNetworkAccess(null);
        } else if (this.getNetworkAccess() instanceof VirtualNetworkAccess) {
            ((VirtualNetworkAccess)this.net)._release();
            this.setNetworkAccess(null);
        }
    }

    public NetworkAccess getCorbaObject() {
        if (this.getNetworkAccess() instanceof ProxyNetworkAccess) {
            return ((ProxyNetworkAccess)this.getNetworkAccess()).getCorbaObject();
        }
        return this.getNetworkAccess();
    }

    @Override
    public String getServerDNS() {
        if (this.getNetworkAccess() instanceof ProxyNetworkAccess) {
            return ((ProxyNetworkAccess)this.getNetworkAccess()).getServerDNS();
        }
        return this.getNetworkAccess().getClass().getName() + ":Unknown";
    }

    @Override
    public String getServerName() {
        if (this.getNetworkAccess() instanceof ProxyNetworkAccess) {
            return ((ProxyNetworkAccess)this.getNetworkAccess()).getServerName();
        }
        return null;
    }

    @Override
    public String getFullName() {
        return this.getServerDNS() + "/" + this.getServerName();
    }

    @Override
    public String getServerType() {
        return "NetworkAccess";
    }

    protected void setNetworkAccess(NetworkAccess na) {
        this.net = na;
    }

    public NetworkAttr get_attributes() {
        return this.getNetworkAccess().get_attributes();
    }

    public Station[] retrieve_stations() {
        return this.getNetworkAccess().retrieve_stations();
    }

    public Channel[] retrieve_for_station(StationId p1) {
        return this.getNetworkAccess().retrieve_for_station(p1);
    }

    public ChannelId[] retrieve_grouping(ChannelId id) throws ChannelNotFound {
        return this.getNetworkAccess().retrieve_grouping(id);
    }

    public ChannelId[][] retrieve_groupings() {
        return this.getNetworkAccess().retrieve_groupings();
    }

    public Channel retrieve_channel(ChannelId id) throws ChannelNotFound {
        return this.getNetworkAccess().retrieve_channel(id);
    }

    public Channel[] retrieve_channels_by_code(String station_code, String site_code, String channel_code) throws ChannelNotFound {
        return this.getNetworkAccess().retrieve_channels_by_code(station_code, site_code, channel_code);
    }

    public Channel[] locate_channels(Area the_area, SamplingRange sampling, OrientationRange orientation) {
        return this.getNetworkAccess().locate_channels(the_area, sampling, orientation);
    }

    public Instrumentation retrieve_instrumentation(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getNetworkAccess().retrieve_instrumentation(id, the_time);
    }

    public Sensitivity retrieve_sensitivity(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.retrieve_instrumentation((ChannelId)id, (Time)the_time).the_response.the_sensitivity;
    }

    public Unit retrieve_initial_units(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.retrieve_instrumentation((ChannelId)id, (Time)the_time).the_response.stages[0].input_units;
    }

    public Unit retrieve_final_units(ChannelId id, Time the_time) throws ChannelNotFound {
        Stage[] stages = this.retrieve_instrumentation((ChannelId)id, (Time)the_time).the_response.stages;
        return stages[stages.length - 1].output_units;
    }

    public Calibration[] retrieve_calibrations(ChannelId id, TimeRange the_time) throws ChannelNotFound, NotImplemented {
        return this.getNetworkAccess().retrieve_calibrations(id, the_time);
    }

    public TimeCorrection[] retrieve_time_corrections(ChannelId id, TimeRange time_range) throws ChannelNotFound, NotImplemented {
        return this.getNetworkAccess().retrieve_time_corrections(id, time_range);
    }

    public ChannelId[] retrieve_all_channels(int seq_max, ChannelIdIterHolder iter) {
        return this.getNetworkAccess().retrieve_all_channels(seq_max, iter);
    }

    public AuditElement[] get_audit_trail_for_channel(ChannelId id) throws ChannelNotFound, NotImplemented {
        return this.getNetworkAccess().get_audit_trail_for_channel(id);
    }

    public AuditElement[] get_audit_trail() throws NotImplemented {
        return this.getNetworkAccess().get_audit_trail();
    }

    public NetworkAccess getNetworkAccess() {
        return this.net;
    }

    public ConcreteNetwork a_writeable() {
        throw new NO_IMPLEMENT();
    }

    public AuditElement[] get_audit_trail_for_site(SiteId id) throws SiteNotFound, NotImplemented {
        throw new NotImplemented();
    }

    public AuditElement[] get_audit_trail_for_station(StationId id) throws StationNotFound, NotImplemented {
        throw new NotImplemented();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getNetworkAccess().toString() + ")";
    }
}

