/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkExplorer;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.SynchronizedNetworkDC;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSNetworkDC
implements ProxyNetworkDC {
    protected SynchronizedNetworkDC netDC;
    protected String serverDNS;
    protected String serverName;
    protected FissuresNamingService namingService;

    public NSNetworkDC(String serverDNS, String serverName, FissuresNamingService fissuresNamingService) {
        if (serverDNS == null || serverDNS.equals("")) {
            throw new IllegalArgumentException("serverDNS cannot be null");
        }
        if (serverName == null || serverName.equals("")) {
            throw new IllegalArgumentException("serverName cannot be null");
        }
        this.serverDNS = serverDNS;
        this.serverName = serverName;
        this.namingService = fissuresNamingService;
    }

    @Override
    public NetworkDCOperations getWrappedDC() {
        return this.getNetworkDC();
    }

    @Override
    public NetworkDCOperations getWrappedDC(Class wrappedClass) {
        if (this.getClass().isAssignableFrom(wrappedClass)) {
            return this;
        }
        NetworkDCOperations tmp = this.getWrappedDC();
        if (tmp instanceof ProxyNetworkDC) {
            return ((ProxyNetworkDC)tmp).getWrappedDC(wrappedClass);
        }
        throw new IllegalArgumentException("Can't find class " + wrappedClass.getName());
    }

    @Override
    public Object getCorbaObject() {
        return this.getNetworkDC().getCorbaObject();
    }

    public FissuresNamingService getFissuresNamingService() {
        return this.namingService;
    }

    @Override
    public String getServerDNS() {
        return this.serverDNS;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public String getFullName() {
        return this.getServerDNS() + "/" + this.getServerName();
    }

    @Override
    public String getServerType() {
        return "NetworkDC";
    }

    @Override
    public synchronized void reset() {
        if (this.netDC != null) {
            this.getCorbaObject()._release();
        }
        this.netDC = null;
    }

    public synchronized ProxyNetworkDC getNetworkDC() {
        if (this.netDC == null) {
            try {
                NetworkDC realDC;
                try {
                    realDC = this.namingService.getNetworkDC(this.serverDNS, this.serverName);
                }
                catch (Throwable t) {
                    this.namingService.reset();
                    realDC = this.namingService.getNetworkDC(this.serverDNS, this.serverName);
                }
                this.netDC = new SynchronizedNetworkDC((NetworkDCOperations)realDC);
            }
            catch (NotFound e) {
                this.repackageException((UserException)e);
            }
            catch (CannotProceed e) {
                this.repackageException((UserException)e);
            }
            catch (InvalidName e) {
                this.repackageException((UserException)e);
            }
        }
        return this.netDC;
    }

    protected void repackageException(UserException e) {
        TRANSIENT t = new TRANSIENT("Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString(), 0, CompletionStatus.COMPLETED_NO);
        t.initCause((Throwable)e);
        throw t;
    }

    public NetworkExplorer a_explorer() {
        try {
            return this.getNetworkDC().a_explorer();
        }
        catch (Throwable e) {
            this.reset();
            return this.getNetworkDC().a_explorer();
        }
    }

    public NetworkFinder a_finder() {
        try {
            return this.getNetworkDC().a_finder();
        }
        catch (Throwable e) {
            this.reset();
            return this.getNetworkDC().a_finder();
        }
    }
}

