/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;

public class LazyNetworkAccess
extends CacheNetworkAccess {
    ProxyNetworkFinder netFinder;

    public LazyNetworkAccess(NetworkAttrImpl attr, ProxyNetworkDC netDC) {
        this(attr, (ProxyNetworkFinder)netDC.a_finder());
    }

    public LazyNetworkAccess(NetworkAttrImpl attr, ProxyNetworkFinder netFinder) {
        super(null);
        this.attr = attr;
        this.netFinder = netFinder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NetworkAccess getNetworkAccess() {
        if (super.getNetworkAccess() != null) return super.getNetworkAccess();
        try {
            if (this.attr.get_code().charAt(0) == '_') {
                NetworkAccess[] nets = this.netFinder.retrieve_by_name(this.attr.get_code());
                if (nets.length == 0) throw new NetworkNotFound();
                this.setNetworkAccess(nets[0]);
                return super.getNetworkAccess();
            } else {
                this.setNetworkAccess(this.netFinder.retrieve_by_id(this.attr.get_id()));
            }
            return super.getNetworkAccess();
        }
        catch (NetworkNotFound e) {
            throw new RuntimeException("unable to reconnect to networkaccess: " + NetworkIdUtil.toString((NetworkAttr)this.attr), e);
        }
    }
}

