/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.LocationUtil;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseRequest {
    private String beginPhase;
    private String endPhase;
    private TimeInterval beginOffset;
    private TimeInterval endOffset;
    private double beginOffsetRatio;
    private double endOffsetRatio;
    private TimeInterval beginOffsetRatioMinimum;
    private TimeInterval endOffsetRatioMinimum;
    private boolean negateBeginOffsetRatio = false;
    private boolean negateEndOffsetRatio = false;
    private TauPUtil util;
    private RequestFilter prevRequestFilter;
    private Location prevOriginLoc;
    private Location prevSiteLoc;
    private Time prevOriginTime;
    private static Logger logger = LoggerFactory.getLogger(PhaseRequest.class);
    private static final String ORIGIN = "origin";

    protected PhaseRequest(String beginPhase, String endPhase, String model) throws TauModelException {
        this.beginPhase = beginPhase;
        this.endPhase = endPhase;
        this.util = TauPUtil.getTauPUtil(model);
    }

    public PhaseRequest(String beginPhase, TimeInterval beginOffest, String endPhase, TimeInterval endOffset, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = beginOffest;
        this.endOffset = endOffset;
    }

    public PhaseRequest(String beginPhase, TimeInterval beginOffset, String endPhase, double endOffestRatio, TimeInterval endOffsetMinimum, boolean negateEndOffsetRatio, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = beginOffset;
        this.endOffset = null;
        this.endOffsetRatio = endOffestRatio;
        this.endOffsetRatioMinimum = endOffsetMinimum;
        this.negateEndOffsetRatio = negateEndOffsetRatio;
    }

    public PhaseRequest(String beginPhase, double beginOffestRatio, TimeInterval beginOffsetMinimum, boolean negateBeginOffsetRatio, String endPhase, TimeInterval endOffset, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = null;
        this.beginOffsetRatio = beginOffestRatio;
        this.beginOffsetRatioMinimum = beginOffsetMinimum;
        this.negateBeginOffsetRatio = negateBeginOffsetRatio;
        this.endOffset = endOffset;
    }

    public PhaseRequest(String beginPhase, double beginOffestRatio, TimeInterval beginOffsetMinimum, boolean negateBeginOffsetRatio, String endPhase, double endOffestRatio, TimeInterval endOffsetMinimum, boolean negateEndOffsetRatio, String model) throws TauModelException {
        this(beginPhase, endPhase, model);
        this.beginOffset = null;
        this.beginOffsetRatio = beginOffestRatio;
        this.beginOffsetRatioMinimum = beginOffsetMinimum;
        this.negateBeginOffsetRatio = negateBeginOffsetRatio;
        this.endOffset = null;
        this.endOffsetRatio = endOffestRatio;
        this.endOffsetRatioMinimum = endOffsetMinimum;
        this.negateEndOffsetRatio = negateEndOffsetRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestFilter generateRequest(EventAccessOperations event, Channel channel) throws Exception {
        OriginImpl origin = EventUtil.extractOrigin(event);
        PhaseRequest phaseRequest = this;
        synchronized (phaseRequest) {
            if (this.prevRequestFilter != null && TimeUtils.areEqual((Time)origin.getOriginTime(), (Time)this.prevOriginTime) && LocationUtil.areEqual((Location)origin.getLocation(), (Location)this.prevOriginLoc) && LocationUtil.areEqual((Location)channel.getSite().getLocation(), (Location)this.prevSiteLoc)) {
                return new RequestFilter(channel.get_id(), this.prevRequestFilter.start_time, this.prevRequestFilter.end_time);
            }
        }
        double begin = this.getArrivalTime(this.beginPhase, channel, (Origin)origin);
        double end = this.getArrivalTime(this.endPhase, channel, (Origin)origin);
        if (begin == -1.0 || end == -1.0) {
            return null;
        }
        MicroSecondDate originDate = new MicroSecondDate(origin.getOriginTime());
        MicroSecondDate bDate = originDate.add(new TimeInterval(begin, UnitImpl.SECOND));
        MicroSecondDate eDate = originDate.add(new TimeInterval(end, UnitImpl.SECOND));
        TimeInterval bInterval = this.beginOffset != null ? this.beginOffset : PhaseRequest.getTimeIntervalFromRatio(bDate, eDate, this.beginOffsetRatio, this.beginOffsetRatioMinimum, this.negateBeginOffsetRatio);
        TimeInterval eInterval = this.endOffset != null ? this.endOffset : PhaseRequest.getTimeIntervalFromRatio(bDate, eDate, this.endOffsetRatio, this.endOffsetRatioMinimum, this.negateEndOffsetRatio);
        bDate = bDate.add(bInterval);
        eDate = eDate.add(eInterval);
        PhaseRequest phaseRequest2 = this;
        synchronized (phaseRequest2) {
            this.prevOriginLoc = origin.getLocation();
            this.prevSiteLoc = channel.getSite().getLocation();
            this.prevOriginTime = origin.getOriginTime();
            this.prevRequestFilter = new RequestFilter(channel.get_id(), bDate.getFissuresTime(), eDate.getFissuresTime());
        }
        logger.debug("Generated request from " + bDate + " to " + eDate + " for " + StationIdUtil.toStringNoDates((StationId)channel.getSite().getStation().get_id()));
        return this.prevRequestFilter;
    }

    private double getArrivalTime(String phase, Channel chan, Origin origin) throws TauModelException {
        if (phase.equals(ORIGIN)) {
            return 0.0;
        }
        String[] phases = new String[]{phase};
        List<Arrival> arrivals = this.util.calcTravelTimes(chan.getSite().getLocation(), origin, phases);
        if (arrivals.size() == 0) {
            return -1.0;
        }
        return Math.rint(1000.0 * arrivals.get(0).getTime()) / 1000.0;
    }

    public static TimeInterval getTimeIntervalFromRatio(MicroSecondDate startPhaseTime, MicroSecondDate endPhaseTime, double ratio, TimeInterval minimumTime, boolean negate) {
        TimeInterval interval = new TimeInterval((Quantity)endPhaseTime.difference(startPhaseTime).multiplyBy(ratio));
        if (interval.lessThan((QuantityImpl)minimumTime)) {
            return PhaseRequest.negateIfTrue(minimumTime, negate);
        }
        return PhaseRequest.negateIfTrue(interval, negate);
    }

    public static TimeInterval negateIfTrue(TimeInterval interval, boolean negate) {
        if (negate) {
            double value = interval.getValue();
            return new TimeInterval(-value, interval.getUnit());
        }
        return interval;
    }

    public String getBeginPhase() {
        return this.beginPhase;
    }

    public String getEndPhase() {
        return this.endPhase;
    }

    public TimeInterval getBeginOffset() {
        return this.beginOffset;
    }

    public TimeInterval getEndOffset() {
        return this.endOffset;
    }

    public double getBeginOffsetRatio() {
        return this.beginOffsetRatio;
    }

    public double getEndOffsetRatio() {
        return this.endOffsetRatio;
    }

    public TimeInterval getBeginOffsetRatioMinimum() {
        return this.beginOffsetRatioMinimum;
    }

    public TimeInterval getEndOffsetRatioMinimum() {
        return this.endOffsetRatioMinimum;
    }

    public boolean isNegateBeginOffsetRatio() {
        return this.negateBeginOffsetRatio;
    }

    public boolean isNegateEndOffsetRatio() {
        return this.negateEndOffsetRatio;
    }
}

