/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.bag.PhaseNonExistent;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhaseCut {
    TauPUtil timeCalc;
    String beginPhase;
    TimeInterval beginOffset;
    String endPhase;
    TimeInterval endOffset;
    Logger logger = LoggerFactory.getLogger(PhaseCut.class);

    public PhaseCut(TauPUtil timeCalc, String beginPhase, TimeInterval beginOffset, String endPhase, TimeInterval endOffset) {
        this.timeCalc = timeCalc;
        this.beginPhase = beginPhase;
        this.beginOffset = beginOffset;
        this.endPhase = endPhase;
        this.endOffset = endOffset;
    }

    public LocalSeismogramImpl cut(Location stationLoc, Origin origin, LocalSeismogramImpl seis) throws TauModelException, PhaseNonExistent, FissuresException {
        List<Arrival> beginArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.beginPhase});
        List<Arrival> endArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.endPhase});
        MicroSecondDate beginTime = null;
        MicroSecondDate endTime = null;
        MicroSecondDate originTime = new MicroSecondDate(origin.getOriginTime());
        if (beginArrivals.size() == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.getLocation());
            throw new PhaseNonExistent("Phase " + this.beginPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        beginTime = originTime.add(new TimeInterval(beginArrivals.get(0).getTime(), UnitImpl.SECOND));
        beginTime = beginTime.add(this.beginOffset);
        if (endArrivals.size() == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.getLocation());
            throw new PhaseNonExistent("Phase " + this.endPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        endTime = originTime.add(new TimeInterval(endArrivals.get(0).getTime(), UnitImpl.SECOND));
        endTime = endTime.add(this.endOffset);
        Cut cut = new Cut(beginTime, endTime);
        return cut.apply(seis);
    }
}

