/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Arithmatic;
import edu.sc.seis.fissuresUtil.bag.ChannelSeismogram;
import edu.sc.seis.fissuresUtil.bag.OrientationUtil;

public class FlippedChannel {
    private static double tol = 0.01;

    public static ChannelSeismogram correct(ChannelImpl chan, LocalSeismogramImpl seis) throws FissuresException {
        return FlippedChannel.correct(chan, seis, null);
    }

    public static ChannelSeismogram correct(ChannelImpl chan, LocalSeismogramImpl seis, Sensitivity sens) throws FissuresException {
        if (FlippedChannel.check((Channel)chan)) {
            return new ChannelSeismogram(OrientationUtil.flip((Channel)chan), (LocalSeismogram)Arithmatic.mul(seis, -1.0f), null);
        }
        return new ChannelSeismogram(chan, (LocalSeismogram)seis, sens);
    }

    public static boolean check(Channel chan) {
        return chan.get_code().charAt(2) == 'Z' && FlippedChannel.check(OrientationUtil.getUp(), chan) || chan.get_code().charAt(2) == 'N' && FlippedChannel.check(OrientationUtil.getNorth(), chan) || chan.get_code().charAt(2) == 'E' && FlippedChannel.check(OrientationUtil.getEast(), chan);
    }

    public static boolean check(Orientation correct, Channel chan) {
        return OrientationUtil.angleBetween(correct, chan.getOrientation()) >= 180.0 - tol;
    }
}

