/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.velocity.SimpleVelocitizer;
import edu.sc.seis.sod.velocity.network.VelocityChannel;
import java.util.ArrayList;
import java.util.List;

public class VelocityRequest {
    private VelocityChannel chan;
    private MicroSecondTimeRange range;

    public VelocityRequest(RequestFilter rf, Channel chan) {
        this(rf, new VelocityChannel((ChannelImpl)chan));
    }

    public VelocityRequest(RequestFilter rf, VelocityChannel chan) {
        this.range = new MicroSecondTimeRange(rf);
        this.chan = chan;
    }

    public MicroSecondDate getBegin() {
        return this.range.getBeginTime();
    }

    public String getBegin(String dateFormat) {
        return SimpleVelocitizer.format(this.getBegin(), dateFormat);
    }

    public MicroSecondDate getEnd() {
        return this.range.getEndTime();
    }

    public String getEnd(String dateFormat) {
        return SimpleVelocitizer.format(this.getEnd(), dateFormat);
    }

    public VelocityChannel getChannel() {
        return this.chan;
    }

    public String toString() {
        return "Request for " + (Object)((Object)this.chan) + " from " + this.getBegin() + " to " + this.getEnd();
    }

    public static List<VelocityRequest> wrap(RequestFilter[] original, Channel chan) {
        ArrayList<VelocityRequest> results = new ArrayList<VelocityRequest>(original.length);
        for (int i = 0; i < original.length; ++i) {
            results.add(new VelocityRequest(original[i], chan));
        }
        return results;
    }

    public static List<List<VelocityRequest>> wrap(RequestFilter[][] original, ChannelGroup channelGroup) {
        ArrayList<List<VelocityRequest>> results = new ArrayList<List<VelocityRequest>>(original.length);
        block0: for (int i = 0; i < channelGroup.getChannels().length; ++i) {
            for (int j = 0; j < original.length; ++j) {
                if (original[j].length == 0 || !ChannelIdUtil.areEqual((ChannelId)channelGroup.getChannels()[i].getId(), (ChannelId)original[j][0].channel_id)) continue;
                results.add(VelocityRequest.wrap(original[j], (Channel)channelGroup.getChannels()[i]));
                continue block0;
            }
        }
        return results;
    }
}

