/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.documenter;

import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.validator.ModelWalker;
import edu.sc.seis.sod.validator.documenter.VelocityModelHelper;
import edu.sc.seis.sod.validator.model.Definition;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.StAXModelBuilder;
import edu.sc.seis.sod.validator.tour.DepthAwareGuide;
import edu.sc.seis.sod.validator.tour.HTMLOutlineTourist;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.BasicConfigurator;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class SchemaDocumenter {
    static ModelWalker walker;
    static String base;
    static String outputdir;

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        if (args.length != 3) {
            System.err.println("Usage: schemaDocumenter rng basedir outputdir");
            System.err.print("       ");
            for (int i = 0; i < args.length; ++i) {
                System.err.print(args[i] + " ");
            }
            System.err.println();
            return;
        }
        String sod_rng = args[0];
        base = args[1];
        if (base.length() != 0 && !base.endsWith("/")) {
            base = base + "/";
        }
        if ((outputdir = args[2]).length() != 0 && !outputdir.endsWith("/")) {
            outputdir = outputdir + "/";
        }
        StAXModelBuilder handler = new StAXModelBuilder(sod_rng);
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("file.resource.loader.path", (Object)(base + "site"));
        ve.setProperty("runtime.log.logsystem.log4j.logger", (Object)"schemaDocumenter");
        ve.init();
        VelocityContext c = new VelocityContext();
        walker = new ModelWalker(handler.getRoot());
        c.put("root", (Object)handler.getRoot());
        c.put("walker", (Object)walker);
        c.put("util", (Object)new SodUtil());
        c.put("helper", (Object)new VelocityModelHelper());
        c.put("doc", (Object)new SchemaDocumenter());
        Collection<Definition> defs = StAXModelBuilder.getAllDefinitions();
        ArrayList<Definition> sortedDefs = new ArrayList<Definition>();
        sortedDefs.addAll(defs);
        Collections.sort(sortedDefs, new Comparator<Definition>(){

            @Override
            public int compare(Definition o1, Definition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Definition def : sortedDefs) {
            SchemaDocumenter.render(c, ve, def);
            System.out.print('.');
        }
        System.out.println();
        System.out.println("Finish successfully");
    }

    public static void render(VelocityContext c, VelocityEngine ve, Definition def) throws Exception {
        String path = SchemaDocumenter.makePath(def);
        File velFile = new File(outputdir + path + ".vm");
        velFile.getParentFile().mkdirs();
        BufferedWriter w = new BufferedWriter(new FileWriter(velFile));
        c.put("def", (Object)def);
        HTMLOutlineTourist tourist = new HTMLOutlineTourist(SchemaDocumenter.makePath(def));
        DepthAwareGuide guide = new DepthAwareGuide(def.getForm());
        guide.lead(tourist);
        c.put("contained", (Object)tourist.getResult());
        ve.mergeTemplate("elementPage.vm", (Context)new VelocityContext((Context)c), (Writer)w);
        ((Writer)w).close();
    }

    public static Definition getNearestDef(Form f) {
        if (f.isFromDef()) {
            return f.getDef();
        }
        return SchemaDocumenter.getNearestDef(f.getParent());
    }

    public static String makePath(Form f) {
        return SchemaDocumenter.makePath(SchemaDocumenter.getNearestDef(f));
    }

    public static String makePath(Definition def) {
        String rngLoc = def.getGrammar().getLoc();
        String path = rngLoc.substring(rngLoc.indexOf("relax") + 6, rngLoc.length() - 4);
        path = "/" + def.getName();
        if (def.getName().equals("")) {
            path = path + "start";
        }
        return path;
    }
}

